/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.job.core.IJobExecutor;
import com.aizuda.snailjob.client.job.core.cache.FutureCache;
import com.aizuda.snailjob.client.job.core.cache.ThreadPoolCache;
import com.aizuda.snailjob.client.job.core.dto.JobArgs;
import com.aizuda.snailjob.client.job.core.dto.MapArgs;
import com.aizuda.snailjob.client.job.core.dto.MergeReduceArgs;
import com.aizuda.snailjob.client.job.core.dto.ReduceArgs;
import com.aizuda.snailjob.client.job.core.dto.ShardingJobArgs;
import com.aizuda.snailjob.client.job.core.executor.JobContextManager;
import com.aizuda.snailjob.client.job.core.executor.JobExecutorFutureCallback;
import com.aizuda.snailjob.client.job.core.log.JobLogMeta;
import com.aizuda.snailjob.client.job.core.timer.StopTaskTimerTask;
import com.aizuda.snailjob.client.job.core.timer.TimerManager;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.MapReduceStageEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.model.JobContext;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.model.dto.ExecuteResult;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobExecutor
implements IJobExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJobExecutor.class);

    @Override
    public void jobExecute(JobContext jobContext) {
        Integer parallelNum = Optional.ofNullable(jobContext.getParallelNum()).orElse(1);
        ThreadPoolExecutor threadPool = ThreadPoolCache.createThreadPool(jobContext.getTaskBatchId(), Math.max(1, parallelNum));
        ListeningExecutorService decorator = MoreExecutors.listeningDecorator((ExecutorService)threadPool);
        TimerManager.add(new StopTaskTimerTask(jobContext.getTaskBatchId()), jobContext.getExecutorTimeout().intValue(), TimeUnit.SECONDS);
        jobContext.setChangeWfContext((Map)Maps.newConcurrentMap());
        ListenableFuture submit = decorator.submit(() -> {
            JobArgs jobArgs = jobContext.getTaskType().intValue() == JobTaskTypeEnum.SHARDING.getType() ? AbstractJobExecutor.buildShardingJobArgs(jobContext) : (Lists.newArrayList((Object[])new Integer[]{JobTaskTypeEnum.MAP_REDUCE.getType(), JobTaskTypeEnum.MAP.getType()}).contains(jobContext.getTaskType()) ? (MapReduceStageEnum.MAP.getStage() == jobContext.getMrStage().intValue() ? AbstractJobExecutor.buildMapJobArgs(jobContext) : (MapReduceStageEnum.REDUCE.getStage() == jobContext.getMrStage().intValue() ? AbstractJobExecutor.buildReduceJobArgs(jobContext) : AbstractJobExecutor.buildMergeReduceJobArgs(jobContext))) : AbstractJobExecutor.buildJobArgs(jobContext));
            jobArgs.setWfContext(jobContext.getWfContext());
            jobArgs.setChangeWfContext(jobContext.getChangeWfContext());
            jobArgs.setJobId(jobContext.getJobId());
            try {
                this.initLogContext(jobContext);
                ExecuteResult executeResult = this.doJobExecute(jobArgs);
                return executeResult;
            }
            finally {
                SnailJobLogManager.removeLogMeta();
                JobContextManager.removeJobContext();
            }
        });
        FutureCache.addFuture(jobContext.getTaskBatchId(), (ListenableFuture<ExecuteResult>)submit);
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new JobExecutorFutureCallback(jobContext), (Executor)decorator);
    }

    private void initLogContext(JobContext jobContext) {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(jobContext.getNamespaceId());
        logMeta.setTaskId(jobContext.getTaskId());
        logMeta.setGroupName(jobContext.getGroupName());
        logMeta.setJobId(jobContext.getJobId());
        logMeta.setTaskBatchId(jobContext.getTaskBatchId());
        SnailJobLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
        JobContextManager.setJobContext(jobContext);
    }

    private static JobArgs buildJobArgs(JobContext jobContext) {
        JobArgs jobArgs = new JobArgs();
        jobArgs.setJobParams(jobContext.getJobArgsHolder().getJobParams());
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        jobArgs.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        jobArgs.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        return jobArgs;
    }

    private static JobArgs buildShardingJobArgs(JobContext jobContext) {
        ShardingJobArgs jobArgs = new ShardingJobArgs();
        jobArgs.setJobParams(jobContext.getJobArgsHolder().getJobParams());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setShardingIndex(jobContext.getShardingIndex());
        jobArgs.setShardingTotal(jobContext.getShardingTotal());
        jobArgs.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        jobArgs.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        return jobArgs;
    }

    private static JobArgs buildMapJobArgs(JobContext jobContext) {
        MapArgs jobArgs = new MapArgs();
        JobArgsHolder jobArgsHolder = jobContext.getJobArgsHolder();
        jobArgs.setJobParams(jobArgsHolder.getJobParams());
        jobArgs.setMapResult(jobArgsHolder.getMaps());
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setTaskName(jobContext.getTaskName());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        jobArgs.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        jobArgs.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        return jobArgs;
    }

    private static JobArgs buildReduceJobArgs(JobContext jobContext) {
        ReduceArgs jobArgs = new ReduceArgs();
        JobArgsHolder jobArgsHolder = jobContext.getJobArgsHolder();
        jobArgs.setJobParams(jobArgsHolder.getJobParams());
        Object maps = jobArgsHolder.getMaps();
        if (Objects.nonNull(maps)) {
            if (maps instanceof String) {
                jobArgs.setMapResult(JsonUtil.parseList((String)((String)maps), Object.class));
            } else {
                jobArgs.setMapResult((List)maps);
            }
        }
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        jobArgs.setWfContext(jobContext.getWfContext());
        jobArgs.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        jobArgs.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        return jobArgs;
    }

    private static JobArgs buildMergeReduceJobArgs(JobContext jobContext) {
        MergeReduceArgs jobArgs = new MergeReduceArgs();
        JobArgsHolder jobArgsHolder = jobContext.getJobArgsHolder();
        jobArgs.setJobParams(jobArgsHolder.getJobParams());
        Object reduces = jobArgsHolder.getReduces();
        if (Objects.nonNull(reduces)) {
            if (reduces instanceof String) {
                jobArgs.setReduces(JsonUtil.parseList((String)((String)reduces), Object.class));
            } else {
                jobArgs.setReduces((List)reduces);
            }
        }
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        jobArgs.setWfContext(jobContext.getWfContext());
        jobArgs.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        jobArgs.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        return jobArgs;
    }

    protected abstract ExecuteResult doJobExecute(JobArgs var1);
}

