/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.alarm.email.Mail;
import com.aizuda.snailjob.common.core.alarm.email.MailAccount;
import com.aizuda.snailjob.common.core.alarm.email.UserPassAuthenticator;
import jakarta.mail.Session;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MailUtils {
    private static MailAccount account;

    public static MailAccount getMailAccount() {
        return account;
    }

    public static void setMailAccount(MailAccount account) {
        MailUtils.account = account;
    }

    public static MailAccount getMailAccount(String from, String user, String pass) {
        account.setFrom(StrUtil.blankToDefault((CharSequence)from, (String)account.getFrom()));
        account.setUser(StrUtil.blankToDefault((CharSequence)user, (String)account.getUser()));
        account.setPass(StrUtil.blankToDefault((CharSequence)pass, (String)account.getPass()));
        return account;
    }

    public static String sendText(String to, String subject, String content, File ... files) {
        return MailUtils.send(to, subject, content, false, files);
    }

    public static String sendHtml(String to, String subject, String content, File ... files) {
        return MailUtils.send(to, subject, content, true, files);
    }

    public static String send(String to, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.splitAddress(to), subject, content, isHtml, files);
    }

    public static String send(String to, String cc, String bcc, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.splitAddress(to), MailUtils.splitAddress(cc), MailUtils.splitAddress(bcc), subject, content, isHtml, files);
    }

    public static String sendText(Collection<String> tos, String subject, String content, File ... files) {
        return MailUtils.send(tos, subject, content, false, files);
    }

    public static String sendHtml(Collection<String> tos, String subject, String content, File ... files) {
        return MailUtils.send(tos, subject, content, true, files);
    }

    public static String send(Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(tos, null, null, subject, content, isHtml, files);
    }

    public static String send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.getMailAccount(), true, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, MailUtils.splitAddress(to), subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, tos, null, null, subject, content, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, false, tos, ccs, bccs, subject, content, null, isHtml, files);
    }

    public static String sendHtml(String to, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return MailUtils.send(to, subject, content, imageMap, true, files);
    }

    public static String send(String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String send(String to, String cc, String bcc, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.splitAddress(to), MailUtils.splitAddress(cc), MailUtils.splitAddress(bcc), subject, content, imageMap, isHtml, files);
    }

    public static String sendHtml(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, File ... files) {
        return MailUtils.send(tos, subject, content, imageMap, true, files);
    }

    public static String send(Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(MailUtils.getMailAccount(), true, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, String to, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, MailUtils.splitAddress(to), subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, tos, null, null, subject, content, imageMap, isHtml, files);
    }

    public static String send(MailAccount mailAccount, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        return MailUtils.send(mailAccount, false, tos, ccs, bccs, subject, content, imageMap, isHtml, files);
    }

    public static Session getSession(MailAccount mailAccount, boolean isSingleton) {
        UserPassAuthenticator authenticator = null;
        if (mailAccount.isAuth().booleanValue()) {
            authenticator = new UserPassAuthenticator(mailAccount.getUser(), mailAccount.getPass());
        }
        return isSingleton ? Session.getDefaultInstance((Properties)mailAccount.getSmtpProps(), authenticator) : Session.getInstance((Properties)mailAccount.getSmtpProps(), authenticator);
    }

    private static String send(MailAccount mailAccount, boolean useGlobalSession, Collection<String> tos, Collection<String> ccs, Collection<String> bccs, String subject, String content, Map<String, InputStream> imageMap, boolean isHtml, File ... files) {
        Mail mail = Mail.create(mailAccount).setUseGlobalSession(useGlobalSession);
        if (CollUtil.isNotEmpty(ccs)) {
            mail.setCcs(ccs.toArray(new String[0]));
        }
        if (CollUtil.isNotEmpty(bccs)) {
            mail.setBccs(bccs.toArray(new String[0]));
        }
        mail.setTos(tos.toArray(new String[0]));
        mail.setTitle(subject);
        mail.setContent(content);
        mail.setHtml(isHtml);
        mail.setFiles(files);
        if (MapUtil.isNotEmpty(imageMap)) {
            for (Map.Entry<String, InputStream> entry : imageMap.entrySet()) {
                mail.addImage(entry.getKey(), entry.getValue());
                IoUtil.close((Closeable)entry.getValue());
            }
        }
        return mail.send();
    }

    private static List<String> splitAddress(String addresses) {
        if (StrUtil.isBlank((CharSequence)addresses)) {
            return null;
        }
        List result = StrUtil.contains((CharSequence)addresses, (char)',') ? StrUtil.splitTrim((CharSequence)addresses, (char)',') : (StrUtil.contains((CharSequence)addresses, (char)';') ? StrUtil.splitTrim((CharSequence)addresses, (char)';') : CollUtil.newArrayList((Object[])new String[]{addresses}));
        return result;
    }

    private MailUtils() {
    }
}

