/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.common.core.annotation.OriginalControllerReturnValue;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportNotifyRecipientVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientQueryVO;
import com.aizuda.snailjob.server.web.model.request.NotifyRecipientRequestVO;
import com.aizuda.snailjob.server.web.model.response.CommonLabelValueResponseVO;
import com.aizuda.snailjob.server.web.model.response.NotifyRecipientResponseVO;
import com.aizuda.snailjob.server.web.service.NotifyRecipientService;
import com.aizuda.snailjob.server.web.util.ExportUtils;
import com.aizuda.snailjob.server.web.util.ImportUtils;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/notify-recipient"})
public class NotifyRecipientController {
    private final NotifyRecipientService notifyRecipientService;

    @PostMapping
    @LoginRequired
    public Boolean saveNotifyRecipient(@RequestBody @Validated NotifyRecipientRequestVO requestVO) {
        return this.notifyRecipientService.saveNotifyRecipient(requestVO);
    }

    @PutMapping
    @LoginRequired
    public Boolean updateNotifyRecipient(@RequestBody @Validated NotifyRecipientRequestVO requestVO) {
        return this.notifyRecipientService.updateNotifyRecipient(requestVO);
    }

    @GetMapping(value={"/page/list"})
    @LoginRequired
    public PageResult<List<NotifyRecipientResponseVO>> getNotifyRecipientPageList(NotifyRecipientQueryVO queryVO) {
        return this.notifyRecipientService.getNotifyRecipientPageList(queryVO);
    }

    @GetMapping(value={"/list"})
    @LoginRequired
    public List<CommonLabelValueResponseVO> getNotifyRecipientList() {
        return this.notifyRecipientService.getNotifyRecipientList();
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean batchDeleteByIds(@RequestBody @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") @NotEmpty(message="ids\u4e0d\u80fd\u4e3a\u7a7a") Set<Long> ids) {
        return this.notifyRecipientService.batchDeleteByIds(ids);
    }

    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    @LoginRequired(role=RoleEnum.ADMIN)
    public void importScene(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.notifyRecipientService.importNotifyRecipient(ImportUtils.parseList(file, NotifyRecipientRequestVO.class));
    }

    @PostMapping(value={"/export"})
    @LoginRequired
    @OriginalControllerReturnValue
    public ResponseEntity<String> exportGroup(@RequestBody ExportNotifyRecipientVO exportNotifyRecipientVO) {
        return ExportUtils.doExport(this.notifyRecipientService.exportNotifyRecipient(exportNotifyRecipientVO));
    }

    public NotifyRecipientController(NotifyRecipientService notifyRecipientService) {
        this.notifyRecipientService = notifyRecipientService;
    }
}

