/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.DecisionConfigRequest;
import com.aizuda.snailjob.model.request.JobTaskConfigRequest;
import com.aizuda.snailjob.model.response.base.WorkflowDetailResponse;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.web.model.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.web.service.convert.WorkflowWebConverter;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WorkflowWebHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowWebHandler.class);
    private final WorkflowNodeMapper workflowNodeMapper;

    public WorkflowDetailResponse.NodeConfig buildNodeConfig(MutableGraph<Long> graph, Long parentId, Map<Long, WorkflowDetailResponse.NodeConfig> nodeConfigMap, Map<Long, WorkflowDetailResponse.NodeInfo> workflowNodeMap) {
        Set successors = graph.successors((Object)parentId);
        if (CollUtil.isEmpty((Collection)successors)) {
            return null;
        }
        WorkflowDetailResponse.NodeInfo previousNodeInfo = workflowNodeMap.get(parentId);
        WorkflowDetailResponse.NodeConfig currentConfig = new WorkflowDetailResponse.NodeConfig();
        currentConfig.setConditionNodes((List)Lists.newArrayList());
        boolean mount = false;
        for (Long successor : Sets.newTreeSet((Iterable)successors)) {
            Set predecessors = graph.predecessors((Object)successor);
            WorkflowDetailResponse.NodeInfo nodeInfo = workflowNodeMap.get(successor);
            currentConfig.setNodeType(nodeInfo.getNodeType());
            currentConfig.getConditionNodes().add(nodeInfo);
            nodeConfigMap.put(successor, currentConfig);
            if (predecessors.size() >= 2) {
                Object predecessor2;
                HashMap<Long, TreeSet> sets = new HashMap<Long, TreeSet>();
                for (Object predecessor2 : predecessors) {
                    TreeSet set = Sets.newTreeSet();
                    sets.put((Long)predecessor2, set);
                    this.findCommonAncestor((Long)predecessor2, set, graph);
                }
                Set intersection = (Set)sets.values().stream().findFirst().get();
                predecessor2 = sets.values().iterator();
                while (predecessor2.hasNext()) {
                    Set value = (Set)predecessor2.next();
                    intersection = Sets.intersection((Set)value, (Set)intersection);
                }
                Long commonAncestor = (Long)intersection.stream().toList().get(intersection.size() - 1);
                WorkflowDetailResponse.NodeConfig parentNodeConfig = nodeConfigMap.get(Sets.newTreeSet((Iterable)graph.successors((Object)commonAncestor)).stream().findFirst().get());
                parentNodeConfig.setChildNode(currentConfig);
                mount = false;
            } else {
                mount = true;
            }
            this.buildNodeConfig(graph, successor, nodeConfigMap, workflowNodeMap);
        }
        if (!parentId.equals(SystemConstants.ROOT) && mount) {
            previousNodeInfo.setChildNode(currentConfig);
        }
        currentConfig.getConditionNodes().sort(Comparator.comparing(WorkflowDetailResponse.NodeInfo::getPriorityLevel));
        return currentConfig;
    }

    private void findCommonAncestor(Long predecessor, Set<Long> set, MutableGraph<Long> graph) {
        Set predecessors = graph.predecessors((Object)predecessor);
        if (CollUtil.isEmpty((Collection)predecessors)) {
            return;
        }
        set.addAll(predecessors);
        this.findCommonAncestor((Long)new ArrayList(predecessors).get(0), set, graph);
    }

    public void buildGraph(List<Long> parentIds, LinkedBlockingDeque<Long> deque, String groupName, Long workflowId, WorkflowRequestVO.NodeConfig nodeConfig, MutableGraph<Long> graph, Integer version, String namespaceId) {
        WorkflowRequestVO.NodeConfig childNode;
        if (Objects.isNull(nodeConfig)) {
            return;
        }
        LinkedBlockingDeque<Long> tempDeque = null;
        List<WorkflowRequestVO.NodeInfo> conditionNodes = nodeConfig.getConditionNodes();
        if (CollUtil.isNotEmpty(conditionNodes)) {
            if (Objects.nonNull(nodeConfig.getChildNode())) {
                tempDeque = new LinkedBlockingDeque<Long>();
            }
            conditionNodes = conditionNodes.stream().sorted(Comparator.comparing(WorkflowRequestVO.NodeInfo::getPriorityLevel)).collect(Collectors.toList());
            for (WorkflowRequestVO.NodeInfo nodeInfo : conditionNodes) {
                WorkflowNode workflowNode = WorkflowWebConverter.INSTANCE.convert(nodeInfo);
                workflowNode.setWorkflowId(workflowId);
                workflowNode.setGroupName(groupName);
                workflowNode.setNodeType(nodeConfig.getNodeType());
                workflowNode.setVersion(version);
                workflowNode.setNamespaceId(namespaceId);
                if (WorkflowNodeTypeEnum.DECISION.getType() == nodeConfig.getNodeType().intValue()) {
                    workflowNode.setJobId(SystemConstants.DECISION_JOB_ID);
                    DecisionConfigRequest decision = nodeInfo.getDecision();
                    Assert.notNull((Object)decision, () -> new SnailJobServerException("Configuration information for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notBlank((CharSequence)decision.getNodeExpression(), () -> new SnailJobServerException("Expression for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)decision.getDefaultDecision(), () -> new SnailJobServerException("Default decision for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)decision.getExpressionType(), () -> new SnailJobServerException("Expression type for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    workflowNode.setNodeInfo(JsonUtil.toJsonString((Object)decision));
                }
                if (WorkflowNodeTypeEnum.JOB_TASK.getType() == nodeConfig.getNodeType().intValue()) {
                    JobTaskConfigRequest jobTask = nodeInfo.getJobTask();
                    Assert.notNull((Object)jobTask, () -> new SnailJobServerException("Configuration information for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    Assert.notNull((Object)jobTask.getJobId(), () -> new SnailJobServerException("Associated task for [{}] cannot be empty", new Object[]{nodeInfo.getNodeName()}));
                    workflowNode.setJobId(jobTask.getJobId());
                }
                Assert.isTrue((1 == this.workflowNodeMapper.insert((Object)workflowNode) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new workflow node failed"));
                graph.addNode((Object)workflowNode.getId());
                for (Long parentId : parentIds) {
                    graph.putEdge((Object)parentId, (Object)workflowNode.getId());
                }
                WorkflowRequestVO.NodeConfig childNode2 = nodeInfo.getChildNode();
                if (Objects.nonNull(childNode2) && CollUtil.isNotEmpty(childNode2.getConditionNodes())) {
                    this.buildGraph(Lists.newArrayList((Object[])new Long[]{workflowNode.getId()}), Objects.isNull(tempDeque) ? deque : tempDeque, groupName, workflowId, childNode2, graph, version, namespaceId);
                    continue;
                }
                if (WorkflowNodeTypeEnum.DECISION.getType() == nodeConfig.getNodeType().intValue()) {
                    throw new SnailJobServerException("Decision nodes or successor nodes of decision nodes cannot be leaf nodes");
                }
                if (Objects.nonNull(tempDeque)) {
                    tempDeque.add(workflowNode.getId());
                    continue;
                }
                deque.add(workflowNode.getId());
            }
        }
        if (Objects.nonNull(childNode = nodeConfig.getChildNode()) && CollUtil.isNotEmpty(childNode.getConditionNodes())) {
            ArrayList list = Lists.newArrayList();
            if (Objects.nonNull(tempDeque)) {
                tempDeque.drainTo(list);
            }
            this.buildGraph(list, deque, groupName, workflowId, childNode, graph, version, namespaceId);
        }
    }

    @Generated
    public WorkflowWebHandler(WorkflowNodeMapper workflowNodeMapper) {
        this.workflowNodeMapper = workflowNodeMapper;
    }
}

