/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.convert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.model.request.DecisionConfigRequest;
import com.aizuda.snailjob.model.request.JobTaskConfigRequest;
import com.aizuda.snailjob.server.common.dto.PointInTimeDTO;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.TriggerIntervalUtils;
import com.aizuda.snailjob.server.web.model.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowDetailResponseWebVO;
import com.aizuda.snailjob.server.web.model.response.WorkflowResponseVO;
import com.aizuda.snailjob.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowTaskBatch;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface WorkflowWebConverter {
    public static final WorkflowWebConverter INSTANCE = (WorkflowWebConverter)Mappers.getMapper(WorkflowWebConverter.class);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(WorkflowWebConverter.toNotifyIdsStr(workflowRequestVO.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowWebConverter.toTriggerInterval(workflowRequestVO))")})
    public Workflow convert(WorkflowRequestVO var1);

    public WorkflowNode convert(WorkflowRequestVO.NodeInfo var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(WorkflowWebConverter.toNotifyIds(workflow.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowWebConverter.toTriggerInterval(workflow))"), @Mapping(target="ownerId", expression="java(WorkflowWebConverter.getOwnerId(workflow))")})
    public WorkflowDetailResponseWebVO convert(Workflow var1);

    @Mappings(value={@Mapping(target="notifyIds", expression="java(WorkflowWebConverter.toNotifyIds(workflow.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowWebConverter.toTriggerInterval(workflow))")})
    public WorkflowRequestVO convertToWorkflowRequestVo(Workflow var1);

    public List<WorkflowDetailResponseVO.NodeInfo> convertList(List<WorkflowNode> var1);

    @Mappings(value={@Mapping(target="decision", expression="java(WorkflowWebConverter.parseDecisionConfig(workflowNode))"), @Mapping(target="jobTask", expression="java(WorkflowWebConverter.parseJobTaskConfig(workflowNode))")})
    public WorkflowDetailResponseVO.NodeInfo convert(WorkflowNode var1);

    public List<WorkflowResponseVO> convertListToWorkflowList(List<Workflow> var1);

    @Mappings(value={@Mapping(target="nextTriggerAt", expression="java(WorkflowWebConverter.toLocalDateTime(workflow.getNextTriggerAt()))"), @Mapping(target="notifyIds", expression="java(WorkflowWebConverter.toNotifyIds(workflow.getNotifyIds()))"), @Mapping(target="triggerInterval", expression="java(WorkflowWebConverter.toTriggerInterval(workflow))")})
    public WorkflowResponseVO convertToWorkflow(Workflow var1);

    public List<WorkflowBatchResponseVO> convertListToWorkflowBatchList(List<WorkflowBatchResponseDO> var1);

    @Mappings(value={@Mapping(source="workflowTaskBatch.groupName", target="groupName"), @Mapping(source="workflowTaskBatch.id", target="id"), @Mapping(source="workflowTaskBatch.createDt", target="createDt"), @Mapping(target="executionAt", expression="java(WorkflowWebConverter.toLocalDateTime(workflowTaskBatch.getExecutionAt()))")})
    public WorkflowBatchResponseVO convert(WorkflowTaskBatch var1, Workflow var2);

    public static Long getOwnerId(Workflow workflow) {
        return Objects.nonNull(workflow.getOwnerId()) && workflow.getOwnerId() > 0L ? workflow.getOwnerId() : null;
    }

    public static LocalDateTime toLocalDateTime(Long nextTriggerAt) {
        if (Objects.isNull(nextTriggerAt) || nextTriggerAt == 0L) {
            return null;
        }
        return DateUtils.toLocalDateTime((Long)nextTriggerAt);
    }

    public static DecisionConfigRequest parseDecisionConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.DECISION.getType() == workflowNode.getNodeType().intValue()) {
            return (DecisionConfigRequest)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfigRequest.class);
        }
        return null;
    }

    public static JobTaskConfigRequest parseJobTaskConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.JOB_TASK.getType() == workflowNode.getNodeType().intValue()) {
            JobTaskConfigRequest jobTaskConfigRequest = new JobTaskConfigRequest();
            jobTaskConfigRequest.setJobId(workflowNode.getJobId());
            return jobTaskConfigRequest;
        }
        return null;
    }

    public static Set<Long> toNotifyIds(String notifyIds) {
        if (StrUtil.isBlank((CharSequence)notifyIds)) {
            return new HashSet<Long>();
        }
        return new HashSet<Long>(JsonUtil.parseList((String)notifyIds, Long.class));
    }

    public static String toNotifyIdsStr(Set<Long> notifyIds) {
        if (CollUtil.isEmpty(notifyIds)) {
            return "";
        }
        return JsonUtil.toJsonString(notifyIds);
    }

    public static String toTriggerInterval(WorkflowRequestVO requestVO) {
        String triggerInterval = requestVO.getTriggerInterval();
        if (StrUtil.isBlank((CharSequence)triggerInterval) || Objects.isNull(requestVO.getTriggerType())) {
            return "";
        }
        return TriggerIntervalUtils.getPointInTimeStr((String)triggerInterval, (Integer)requestVO.getTriggerType());
    }

    public static String toTriggerInterval(Workflow workflow) {
        String triggerInterval = workflow.getTriggerInterval();
        Integer triggerType = workflow.getTriggerType();
        if (WaitStrategies.WaitStrategyEnum.POINT_IN_TIME.getType().equals(triggerType)) {
            List pointInTimeDTOS = JsonUtil.parseList((String)triggerInterval, PointInTimeDTO.class);
            List<String> timeStrList = pointInTimeDTOS.stream().map(time -> DateUtils.format((LocalDateTime)DateUtils.toLocalDateTime((Long)time.getTime()))).toList();
            return JsonUtil.toJsonString(timeStrList);
        }
        return triggerInterval;
    }
}

