/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.socket;

import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.server.common.enums.WebSocketSceneEnum;
import com.aizuda.snailjob.server.web.config.WebSocketConfigurator;
import com.aizuda.snailjob.server.web.model.event.WsRequestEvent;
import com.aizuda.snailjob.server.web.model.event.WsSendEvent;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpoint;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket", configurator=WebSocketConfigurator.class)
public class LogServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogServer.class);
    public static final ConcurrentHashMap<String, Session> USER_SESSION = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void sendMessage(WsSendEvent message) throws IOException {
        Session session = USER_SESSION.get(message.getSid());
        if (Objects.isNull(session)) {
            log.warn("{} ws session not exist", (Object)message.getSid());
            return;
        }
        if (session.isOpen()) {
            Session session2 = session;
            synchronized (session2) {
                session.getBasicRemote().sendText(message.getMessage());
            }
        }
    }

    @OnOpen
    public void onOpen(Session session) {
        Map userProperties = session.getUserProperties();
        String sid = (String)userProperties.get("sid");
        USER_SESSION.put(sid, session);
        log.info("sid:[{}] websocket started", (Object)sid);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        Map userProperties = session.getUserProperties();
        String sid = (String)userProperties.get("sid");
        String scene = (String)userProperties.get("scene");
        WsRequestEvent requestVO = new WsRequestEvent(this);
        requestVO.setSceneEnum(WebSocketSceneEnum.valueOf((String)scene));
        requestVO.setMessage(message);
        requestVO.setSid(sid);
        SnailSpringContext.getContext().publishEvent((ApplicationEvent)requestVO);
    }

    @OnClose
    public void onClose(Session session) {
        Map userProperties = session.getUserProperties();
        String sid = (String)userProperties.get("sid");
        log.info("sid:[{}] websocket closed", (Object)sid);
        USER_SESSION.remove(sid);
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        log.error("Error occurred {}", throwable);
    }
}

