/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseDataUpdater;
import com.clickhouse.data.ClickHouseOutputStream;
import com.clickhouse.data.ClickHousePassThruStream;
import com.clickhouse.logging.Logger;
import com.clickhouse.logging.LoggerFactory;
import java.io.IOException;

@Deprecated
public abstract class AbstractByteArrayOutputStream
extends ClickHouseOutputStream {
    private static final Logger log = LoggerFactory.getLogger(AbstractByteArrayOutputStream.class);
    protected final byte[] buffer;
    protected int position;

    protected void flushBuffer() throws IOException {
        this.flushBuffer(this.buffer, 0, this.position);
        this.position = 0;
    }

    protected abstract void flushBuffer(byte[] var1, int var2, int var3) throws IOException;

    protected AbstractByteArrayOutputStream(ClickHousePassThruStream stream, int bufferSize, Runnable postCloseAction) {
        super(stream, postCloseAction);
        this.buffer = new byte[bufferSize];
        this.position = 0;
    }

    @Override
    public ClickHouseOutputStream transferBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        if (this.position > 0) {
            this.flushBuffer();
        }
        this.flushBuffer(bytes, offset, length);
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBuffer(ClickHouseByteBuffer buffer) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (buffer.isEmpty()) {
            return this;
        }
        this.ensureOpen();
        byte[] b = this.buffer;
        int limit = b.length;
        int length = buffer.length();
        log.debug((Object)"writeBuffer limit:[{}] length:[{}] position:[{}]", limit, length, this.position);
        if (length <= limit - this.position) {
            System.arraycopy(buffer.array(), buffer.position(), b, this.position, length);
            this.position += length;
        } else {
            this.flushBuffer();
            this.flushBuffer(buffer.array(), buffer.position(), buffer.length());
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.buffer[this.position++] = b;
        if (this.position >= this.buffer.length) {
            this.flushBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || length < 0 || length > bytes.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return this;
        }
        this.ensureOpen();
        int limit = this.buffer.length;
        while (length > 0) {
            int remain = limit - this.position;
            if (length < remain) {
                System.arraycopy(bytes, offset, this.buffer, this.position, length);
                this.position += length;
                length = 0;
                continue;
            }
            System.arraycopy(bytes, offset, this.buffer, this.position, remain);
            this.position = limit;
            offset += remain;
            length -= remain;
            this.flushBuffer();
        }
        return this;
    }

    @Override
    public ClickHouseOutputStream writeCustom(ClickHouseDataUpdater writer) throws IOException {
        this.ensureOpen();
        int written = 0;
        while ((written = writer.update(this.buffer, this.position, this.buffer.length)) < 0) {
            this.flushBuffer();
        }
        this.position += written;
        return this;
    }
}

