/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.stream.CapacityPolicy;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.jctools.queues.SpscArrayQueue;
import org.jctools.queues.SpscLinkedQueue;

@Deprecated
public interface AdaptiveQueue<E> {
    public static <E> AdaptiveQueue<E> create(CapacityPolicy policy, E ... array) {
        return new DefaultQueue<E>(policy, array);
    }

    public static <E> AdaptiveQueue<E> create(CapacityPolicy policy, List<E> list) {
        return new DefaultQueue<E>(policy, list);
    }

    public void add(E var1);

    public void clear();

    public boolean offer(E var1);

    public E poll();

    public int size();

    public static final class DefaultQueue<E>
    implements AdaptiveQueue<E> {
        private final CapacityPolicy policy;
        private final LinkedList<E> queue;

        DefaultQueue(CapacityPolicy policy, E ... array) {
            this.policy = policy;
            this.queue = array == null || array.length == 0 ? new LinkedList<E>() : new LinkedList<E>(Arrays.asList(array));
        }

        DefaultQueue(CapacityPolicy policy, List<E> list) {
            this.policy = policy;
            this.queue = new LinkedList<E>(list);
        }

        @Override
        public synchronized void add(E e) {
            this.queue.add(e);
            if (this.policy != null) {
                this.policy.ensureCapacity(0);
            }
        }

        @Override
        public synchronized void clear() {
            this.queue.clear();
            if (this.policy != null) {
                this.policy.ensureCapacity(0);
            }
        }

        @Override
        public synchronized boolean offer(E e) {
            if (this.policy == null || this.policy.ensureCapacity(this.queue.size())) {
                this.queue.addLast(e);
                return true;
            }
            return false;
        }

        @Override
        public synchronized E poll() {
            if (!this.queue.isEmpty()) {
                return this.queue.removeFirst();
            }
            return null;
        }

        @Override
        public synchronized int size() {
            return this.queue.size();
        }
    }

    public static final class JctoolsSpscQueue<E>
    implements AdaptiveQueue<E> {
        private final Queue<E> queue;

        JctoolsSpscQueue(E ... array) {
            if (array == null || array.length == 0) {
                this.queue = new SpscLinkedQueue();
            } else {
                this.queue = new SpscArrayQueue(array.length);
                for (E e : array) {
                    this.queue.offer(e);
                }
            }
        }

        @Override
        public void add(E e) {
            this.queue.offer(e);
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public boolean offer(E e) {
            return this.queue.offer(e);
        }

        @Override
        public E poll() {
            return this.queue.poll();
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

