/*
 * Decompiled with CFR 0.152.
 */
package com.fhs.trans.config;

import com.baomidou.mybatisplus.annotation.TableId;
import com.fhs.cache.service.RedisCacheService;
import com.fhs.cache.service.impl.RedisCacheServiceImpl;
import com.fhs.common.constant.TransConfig;
import com.fhs.common.spring.SpringContextUtil;
import com.fhs.core.trans.vo.VO;
import com.fhs.trans.advice.EasyTransResponseBodyAdvice;
import com.fhs.trans.aop.TransMethodResultAop;
import com.fhs.trans.controller.TransProxyController;
import com.fhs.trans.ds.DataSourceSetter;
import com.fhs.trans.listener.TransMessageListener;
import com.fhs.trans.service.impl.AutoTransService;
import com.fhs.trans.service.impl.DictionaryTransService;
import com.fhs.trans.service.impl.EnumTransService;
import com.fhs.trans.service.impl.RpcTransService;
import com.fhs.trans.service.impl.SimpleTransService;
import com.fhs.trans.service.impl.TransService;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.web.client.RestTemplate;

@Configuration
@ServletComponentScan(value={"com.fhs.trans.filter"})
public class TransServiceConfig
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(TransServiceConfig.class);
    @Value(value="${easy-trans.is-enable-redis:false}")
    private boolean isEnableRedis;
    @Value(value="${easy-trans.multiple-data-sources:false}")
    private boolean multipleDataSources;
    @Value(value="${easy-trans.autotrans.package:com.*.*.service.impl}")
    private String packageNames;
    @Autowired(required=false)
    private DataSourceSetter dataSourceSetter;

    @Bean
    public TransService transService() {
        return new TransService();
    }

    @Bean
    @DependsOn(value={"springContextUtil"})
    public AutoTransService autoTransService() {
        AutoTransService autoTransService = new AutoTransService();
        autoTransService.setPackageNames(this.packageNames);
        return autoTransService;
    }

    @Bean
    public DictionaryTransService dictionaryTransService() {
        return new DictionaryTransService();
    }

    @Bean
    public EnumTransService enumTransService() {
        return new EnumTransService();
    }

    @Bean
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public SimpleTransService simpleTransService(SimpleTransService.SimpleTransDiver dirver) {
        SimpleTransService result = new SimpleTransService();
        result.regsiterTransDiver(dirver);
        return result;
    }

    @Bean
    @LoadBalanced
    @ConditionalOnMissingBean(value={RestTemplate.class})
    public RestTemplate restTemplate(RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public RpcTransService rpcTransService(SimpleTransService.SimpleTransDiver dirver, RestTemplate restTemplate) {
        RpcTransService result = new RpcTransService();
        result.regsiterTransDiver(dirver);
        result.setRestTemplate(restTemplate);
        return result;
    }

    @Bean
    @ConditionalOnBean(value={SimpleTransService.SimpleTransDiver.class})
    public TransProxyController transProxyController(SimpleTransService.SimpleTransDiver dirver) {
        TransProxyController result = new TransProxyController();
        result.setSimpleTransDiver(dirver);
        return result;
    }

    @Bean
    public TransMethodResultAop transMethodResultAop() {
        return new TransMethodResultAop();
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-global"}, havingValue="true")
    public EasyTransResponseBodyAdvice EasyTransResponseBodyAdvice() {
        return new EasyTransResponseBodyAdvice();
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    public TransMessageListener transMessageListener() {
        return new TransMessageListener();
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("trans"));
        StringRedisSerializer seria = new StringRedisSerializer();
        container.setTopicSerializer((RedisSerializer)seria);
        return container;
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    MessageListenerAdapter listenerAdapter(TransMessageListener receiver) {
        MessageListenerAdapter result = new MessageListenerAdapter((Object)receiver, "handelMsg");
        JdkSerializationRedisSerializer valSerializer = new JdkSerializationRedisSerializer();
        result.setSerializer((RedisSerializer)valSerializer);
        return result;
    }

    @Bean
    @ConditionalOnProperty(name={"easy-trans.is-enable-redis"}, havingValue="true")
    public RedisCacheService redisCacheService(RedisTemplate redisTemplate, AutoTransService autoTransService) {
        RedisCacheServiceImpl redisCacheService = new RedisCacheServiceImpl();
        redisCacheService.setRedisTemplate(redisTemplate);
        redisCacheService.setStrRedisTemplate(redisTemplate);
        autoTransService.setRedisTransCache((RedisCacheService)redisCacheService);
        return redisCacheService;
    }

    @Bean(value={"springContextUtil"})
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }

    public void afterPropertiesSet() throws Exception {
        TransConfig.MULTIPLE_DATA_SOURCES = this.multipleDataSources;
        if (TransConfig.MULTIPLE_DATA_SOURCES && this.dataSourceSetter == null) {
            throw new IllegalArgumentException("easytrans \u5982\u679c\u5f00\u542f\u591a\u6570\u636e\u6e90\u652f\u6301\uff0c\u9700\u8981\u81ea\u5b9a\u4e49 DataSourceSetter \u6765\u5207\u6362\u6570\u636e\u6e90");
        }
        TransConfig.dataSourceSetter = this.dataSourceSetter;
        VO.ID_ANNO.add(TableId.class);
        VO.ID_ANNO.add(Id.class);
    }
}

