/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.BatchConsumeBlockingQueueTrigger;
import com.github.phantomthief.collection.impl.LazyBufferTrigger;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class BatchConsumerTriggerBuilder<E> {
    private static final Duration DEFAULT_LINGER = Duration.ofSeconds(1L);
    ScheduledExecutorService scheduledExecutorService;
    boolean usingInnerExecutor;
    Supplier<Duration> linger;
    int batchSize;
    int bufferSize;
    ThrowableConsumer<List<E>, Exception> consumer;
    BiConsumer<Throwable, List<E>> exceptionHandler;

    public BatchConsumerTriggerBuilder<E> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> forceConsumeEveryTick() {
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> tickTime(long time, TimeUnit unit) {
        return this.linger(time, unit);
    }

    public BatchConsumerTriggerBuilder<E> linger(long time, TimeUnit unit) {
        return this.linger(() -> Duration.ofNanos(unit.toNanos(time)));
    }

    public BatchConsumerTriggerBuilder<E> linger(@Nonnull Duration duration) {
        Preconditions.checkNotNull((Object)duration);
        return this.linger(() -> duration);
    }

    public BatchConsumerTriggerBuilder<E> linger(@Nonnull Supplier<Duration> duration) {
        this.linger = (Supplier)Preconditions.checkNotNull(duration);
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> batchConsumerSize(int size) {
        return this.batchSize(size);
    }

    public BatchConsumerTriggerBuilder<E> batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    @Deprecated
    public <E1> BatchConsumerTriggerBuilder<E1> setQueue(BlockingQueue<? extends E> queue) {
        return this;
    }

    @Deprecated
    public <E1> BatchConsumerTriggerBuilder<E1> setConsumer(Consumer<? super List<E1>> consumer) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = consumer::accept;
        return thisBuilder;
    }

    public <E1> BatchConsumerTriggerBuilder<E1> setConsumerEx(ThrowableConsumer<? super List<E1>, Exception> consumer) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = arg_0 -> consumer.accept(arg_0);
        return thisBuilder;
    }

    public <E1> BatchConsumerTriggerBuilder<E1> setExceptionHandler(BiConsumer<? super Throwable, ? super List<E1>> exceptionHandler) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.exceptionHandler = exceptionHandler;
        return thisBuilder;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> queueCapacity(int capacity) {
        return this.bufferSize(capacity);
    }

    public BatchConsumerTriggerBuilder<E> bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public <E1> BufferTrigger<E1> build() {
        return new LazyBufferTrigger(() -> {
            this.ensure();
            return new BatchConsumeBlockingQueueTrigger(this);
        });
    }

    private void ensure() {
        Preconditions.checkNotNull(this.consumer);
        if (this.linger == null) {
            this.linger = () -> DEFAULT_LINGER;
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.makeScheduleExecutor();
            this.usingInnerExecutor = true;
        }
    }

    private ScheduledExecutorService makeScheduleExecutor() {
        return Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pool-batch-consume-blocking-queue-thread-%d").setDaemon(true).build());
    }
}

