/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.BackPressureHandler;
import com.github.phantomthief.collection.impl.GenericSimpleBufferTriggerBuilder;
import com.github.phantomthief.collection.impl.GlobalBackPressureListener;
import com.github.phantomthief.collection.impl.NameRegistry;
import com.github.phantomthief.collection.impl.RejectHandler;
import com.github.phantomthief.collection.impl.SimpleBufferTriggerBuilder;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferTrigger<E, C>
implements BufferTrigger<E> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBufferTrigger.class);
    private static final long DEFAULT_NEXT_TRIGGER_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    private final String name;
    private final AtomicLong counter = new AtomicLong();
    private final ThrowableConsumer<C, Throwable> consumer;
    private final ToIntBiFunction<C, E> queueAdder;
    private final Supplier<C> bufferFactory;
    private final BiConsumer<Throwable, C> exceptionHandler;
    private final AtomicReference<C> buffer = new AtomicReference();
    private final LongSupplier maxBufferCount;
    private final RejectHandler<E> rejectHandler;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private final Condition writeCondition;
    private final Runnable shutdownExecutor;
    private volatile boolean shutdown;
    private volatile long lastConsumeTimestamp = System.currentTimeMillis();

    SimpleBufferTrigger(SimpleBufferTriggerBuilder<E, C> builder) {
        this.name = builder.name;
        this.queueAdder = builder.queueAdder;
        this.bufferFactory = builder.bufferFactory;
        this.consumer = builder.consumer;
        this.exceptionHandler = builder.exceptionHandler;
        this.maxBufferCount = builder.maxBufferCount;
        this.rejectHandler = builder.rejectHandler;
        this.buffer.set(this.bufferFactory.get());
        if (!builder.disableSwitchLock) {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.readLock = lock.readLock();
            this.writeLock = lock.writeLock();
            this.writeCondition = this.writeLock.newCondition();
        } else {
            this.readLock = null;
            this.writeLock = null;
            this.writeCondition = null;
        }
        builder.scheduledExecutorService.schedule(new TriggerRunnable(builder.scheduledExecutorService, builder.triggerStrategy), DEFAULT_NEXT_TRIGGER_PERIOD, TimeUnit.MILLISECONDS);
        this.shutdownExecutor = () -> {
            if (builder.usingInnerExecutor) {
                MoreExecutors.shutdownAndAwaitTermination((ExecutorService)builder.scheduledExecutorService, (long)1L, (TimeUnit)TimeUnit.DAYS);
            }
        };
    }

    @Deprecated
    public static SimpleBufferTriggerBuilder<Object, Object> newBuilder() {
        return new SimpleBufferTriggerBuilder<Object, Object>();
    }

    @Deprecated
    public static <E, C> GenericSimpleBufferTriggerBuilder<E, C> newGenericBuilder() {
        return new GenericSimpleBufferTriggerBuilder(SimpleBufferTrigger.newBuilder());
    }

    public static SimpleBufferTriggerBuilder<Object, Map<Object, Integer>> newCounterBuilder() {
        return new SimpleBufferTriggerBuilder().setContainer(ConcurrentHashMap::new, (map, element) -> {
            map.merge(element, 1, Math::addExact);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(E element) {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"buffer trigger was shutdown.");
        long currentCount = this.counter.get();
        long thisMaxBufferCount = this.maxBufferCount.getAsLong();
        if (thisMaxBufferCount > 0L && currentCount >= thisMaxBufferCount) {
            boolean pass = true;
            if (this.rejectHandler != null) {
                if (this.writeLock != null && this.writeCondition != null) {
                    this.writeLock.lock();
                }
                try {
                    currentCount = this.counter.get();
                    thisMaxBufferCount = this.maxBufferCount.getAsLong();
                    if (thisMaxBufferCount > 0L && currentCount >= thisMaxBufferCount) {
                        pass = this.fireRejectHandler(element);
                    }
                }
                finally {
                    if (this.writeLock != null && this.writeCondition != null) {
                        this.writeLock.unlock();
                    }
                }
            }
            if (!pass) {
                return;
            }
        }
        boolean locked = false;
        if (this.readLock != null) {
            try {
                this.readLock.lock();
                locked = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            C thisBuffer = this.buffer.get();
            int changedCount = this.queueAdder.applyAsInt(thisBuffer, element);
            if (changedCount > 0) {
                this.counter.addAndGet(changedCount);
            }
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }

    private boolean fireRejectHandler(E element) {
        try {
            return this.rejectHandler.onReject(element, this.writeCondition);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manuallyDoTrigger() {
        SimpleBufferTrigger simpleBufferTrigger = this;
        synchronized (simpleBufferTrigger) {
            this.doConsume();
        }
    }

    /*
     * Exception decompiling
     */
    private void doConsume() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public long getPendingChanges() {
        return this.counter.get();
    }

    @Override
    public void close() {
        this.shutdown = true;
        try {
            this.manuallyDoTrigger();
        }
        finally {
            this.shutdownExecutor.run();
        }
    }

    public static void setupGlobalBackPressure(GlobalBackPressureListener listener) {
        BackPressureHandler.setupGlobalBackPressureListener(listener);
    }

    public static void setupGlobalNameRegistry(NameRegistry nameRegistry) {
        SimpleBufferTriggerBuilder.setupGlobalNameRegistry(nameRegistry);
    }

    private class TriggerRunnable
    implements Runnable {
        private final ScheduledExecutorService scheduledExecutorService;
        private final TriggerStrategy triggerStrategy;

        TriggerRunnable(ScheduledExecutorService scheduledExecutorService, TriggerStrategy triggerStrategy) {
            this.scheduledExecutorService = scheduledExecutorService;
            this.triggerStrategy = triggerStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SimpleBufferTrigger simpleBufferTrigger = SimpleBufferTrigger.this;
            synchronized (simpleBufferTrigger) {
                long nextTrigPeriod = DEFAULT_NEXT_TRIGGER_PERIOD;
                try {
                    TriggerResult triggerResult = this.triggerStrategy.canTrigger(SimpleBufferTrigger.this.lastConsumeTimestamp, SimpleBufferTrigger.this.counter.get());
                    nextTrigPeriod = triggerResult.nextPeriod;
                    long beforeConsume = System.currentTimeMillis();
                    if (triggerResult.doConsumer) {
                        SimpleBufferTrigger.this.lastConsumeTimestamp = beforeConsume;
                        SimpleBufferTrigger.this.doConsume();
                    }
                    nextTrigPeriod -= System.currentTimeMillis() - beforeConsume;
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
                nextTrigPeriod = Math.max(0L, nextTrigPeriod);
                if (!SimpleBufferTrigger.this.shutdown) {
                    this.scheduledExecutorService.schedule(this, nextTrigPeriod, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public static class TriggerResult {
        private static final TriggerResult EMPTY = new TriggerResult(false, TimeUnit.DAYS.toMillis(1L));
        private final boolean doConsumer;
        private final long nextPeriod;

        private TriggerResult(boolean doConsumer, long nextPeriod) {
            this.doConsumer = doConsumer;
            this.nextPeriod = nextPeriod;
        }

        public static TriggerResult trig(boolean doConsumer, long nextPeriod) {
            return new TriggerResult(doConsumer, nextPeriod);
        }

        public static TriggerResult empty() {
            return EMPTY;
        }
    }

    public static interface TriggerStrategy {
        public TriggerResult canTrigger(long var1, long var3);
    }
}

