/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.SimpleBufferTrigger;
import com.github.phantomthief.tuple.Tuple;
import com.github.phantomthief.tuple.TwoTuple;
import com.github.phantomthief.util.ThrowableFunction;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class TickerBatchInvoker<K, V>
implements Function<K, CompletableFuture<V>> {
    private final ThrowableFunction<Collection<K>, Map<K, V>, ? extends Throwable> batchInvoker;
    private final Executor executor;
    private final BufferTrigger<TwoTuple<K, CompletableFuture<V>>> bufferTrigger;

    private TickerBatchInvoker(long ticker, ThrowableFunction<Collection<K>, Map<K, V>, ? extends Throwable> batchInvoker, Executor executor) {
        this.batchInvoker = batchInvoker;
        this.executor = executor;
        this.bufferTrigger = SimpleBufferTrigger.newBuilder().setContainer(ConcurrentHashMap::new, this::enqueue).on(ticker, TimeUnit.MILLISECONDS, 1L).consumer(this::batchInvoke).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private boolean enqueue(Map<K, List<CompletableFuture<V>>> map, TwoTuple<K, CompletableFuture<V>> e) {
        map.compute(e.getFirst(), (k, list) -> {
            if (list == null) {
                list = new ArrayList<Object>();
            }
            ArrayList<Object> arrayList = list;
            synchronized (arrayList) {
                list.add(e.getSecond());
            }
            return list;
        });
        return true;
    }

    private void batchInvoke(Map<K, List<CompletableFuture<V>>> map) {
        this.executor.execute(() -> {
            try {
                Map result = (Map)this.batchInvoker.apply(map.keySet());
                map.forEach((key, futures) -> {
                    Object v = result.get(key);
                    List list = futures;
                    synchronized (list) {
                        for (CompletableFuture future : futures) {
                            future.complete(v);
                        }
                    }
                });
            }
            catch (Throwable e) {
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    List futures2;
                    List list = futures2 = (List)iterator.next();
                    synchronized (list) {
                        futures2.stream().filter(future -> !future.isDone()).forEach(future -> future.completeExceptionally(e));
                    }
                }
            }
        });
    }

    @Override
    public CompletableFuture<V> apply(K key) {
        CompletableFuture future = new CompletableFuture();
        this.bufferTrigger.enqueue(Tuple.tuple(key, future));
        return future;
    }

    public static class Builder {
        private long ticker;
        private Executor executor;

        private Builder() {
        }

        public Builder ticker(long time, TimeUnit unit) {
            this.ticker = unit.toMillis(time);
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder threads(int nThreads) {
            this.executor = Executors.newFixedThreadPool(nThreads);
            return this;
        }

        public <K, V> TickerBatchInvoker<K, V> build(ThrowableFunction<Collection<K>, Map<K, V>, ? extends Throwable> batchInvoker) {
            Preconditions.checkNotNull(batchInvoker);
            this.ensure();
            return new TickerBatchInvoker(this.ticker, batchInvoker, this.executor);
        }

        private void ensure() {
            if (this.ticker <= 0L) {
                this.ticker = TimeUnit.SECONDS.toMillis(1L);
            }
            if (this.executor == null) {
                this.executor = Executors.newCachedThreadPool();
            }
        }
    }
}

