/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool;

import com.github.phantomthief.pool.KeyAffinity;
import com.github.phantomthief.pool.KeyAffinityExecutorStats;
import com.github.phantomthief.pool.KeyAffinityExecutorUtils;
import com.github.phantomthief.pool.impl.KeyAffinityExecutorBuilder;
import com.github.phantomthief.util.MoreReflection;
import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface KeyAffinityExecutor<K>
extends KeyAffinity<K, ListeningExecutorService> {
    public static final int DEFAULT_QUEUE_SIZE = 100;

    @Nonnull
    public static KeyAffinityExecutorBuilder newKeyAffinityExecutor() {
        return new KeyAffinityExecutorBuilder();
    }

    @Nonnull
    public static <K> KeyAffinityExecutor<K> newSerializingExecutor(int parallelism, String threadName) {
        return KeyAffinityExecutor.newSerializingExecutor(parallelism, 100, threadName);
    }

    @Nonnull
    public static <K> KeyAffinityExecutor<K> newSerializingExecutor(int parallelism, int queueBufferSize, String threadName) {
        return KeyAffinityExecutor.newKeyAffinityExecutor().parallelism(parallelism).executor(KeyAffinityExecutorUtils.executor(threadName, queueBufferSize)).build();
    }

    @Nonnull
    public static <K> KeyAffinityExecutor<K> newSerializingExecutor(IntSupplier parallelism, IntSupplier queueBufferSize, String threadName) {
        return KeyAffinityExecutor.newKeyAffinityExecutor().parallelism(parallelism).executor(KeyAffinityExecutorUtils.executor(threadName, queueBufferSize)).usingRandom(it -> it > 20).build();
    }

    public <T> ListenableFuture<T> submit(K var1, @Nonnull Callable<T> var2);

    @Deprecated
    default public ListenableFuture<?> execute(K key, @Nonnull Runnable task) {
        Preconditions.checkNotNull((Object)task);
        MoreReflection.logDeprecated("Deprecated calling:KeyAffinityExecutor.execute() at ({}), use executeEx() instead.");
        return this.submit(key, () -> {
            task.run();
            return null;
        });
    }

    public void executeEx(K var1, @Nonnull ThrowableRunnable<Exception> var2);

    @Nullable
    public KeyAffinityExecutorStats stats();

    public static Collection<KeyAffinityExecutor<?>> allExecutorsForStats() {
        return KeyAffinityExecutorBuilder.getAllExecutors();
    }
}

