/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool;

import com.github.phantomthief.pool.impl.DynamicCapacityLinkedBlockingQueue;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class KeyAffinityExecutorUtils {
    public static final int RANDOM_THRESHOLD = 20;

    static Supplier<ExecutorService> executor(final String threadName, final IntSupplier queueBufferSize) {
        return new Supplier<ExecutorService>(){
            private final ThreadFactory threadFactory;
            {
                this.threadFactory = new ThreadFactoryBuilder().setNameFormat(threadName).build();
            }

            @Override
            public ExecutorService get() {
                DynamicCapacityLinkedBlockingQueue<Runnable> queue = new DynamicCapacityLinkedBlockingQueue<Runnable>(queueBufferSize){

                    @Override
                    public boolean offer(Runnable o) {
                        try {
                            this.put(o);
                            return true;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            return false;
                        }
                    }
                };
                return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue, this.threadFactory);
            }
        };
    }

    static Supplier<ExecutorService> executor(final String threadName, final int queueBufferSize) {
        return new Supplier<ExecutorService>(){
            private final ThreadFactory threadFactory;
            {
                this.threadFactory = new ThreadFactoryBuilder().setNameFormat(threadName).build();
            }

            @Override
            public ExecutorService get() {
                LinkedBlockingQueue<Runnable> queue = queueBufferSize > 0 ? new LinkedBlockingQueue<Runnable>(queueBufferSize){

                    @Override
                    public boolean offer(Runnable e) {
                        try {
                            this.put(e);
                            return true;
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                            return false;
                        }
                    }
                } : new LinkedBlockingQueue<Runnable>();
                return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queue, this.threadFactory);
            }
        };
    }
}

