/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.impl.CapacitySettableLinkedBlockingQueue;
import com.github.phantomthief.pool.impl.LazyBlockingQueue;
import com.github.phantomthief.util.SimpleRateLimiter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Predicate;

public class DynamicCapacityLinkedBlockingQueue<E>
implements BlockingQueue<E> {
    private final CapacitySettableLinkedBlockingQueue<E> queue;
    private final IntSupplier capacity;
    private final SimpleRateLimiter rateLimiter;

    public DynamicCapacityLinkedBlockingQueue(IntSupplier capacity) {
        this.capacity = capacity;
        int thisCapacity = capacity.getAsInt();
        this.queue = new CapacitySettableLinkedBlockingQueue(thisCapacity <= 0 ? Integer.MAX_VALUE : thisCapacity);
        this.rateLimiter = SimpleRateLimiter.create(1.0);
    }

    public static <T> BlockingQueue<T> lazyDynamicCapacityLinkedBlockingQueue(IntSupplier capacity) {
        return new LazyBlockingQueue(() -> new DynamicCapacityLinkedBlockingQueue(capacity));
    }

    private void tryCheckCapacity() {
        if (this.rateLimiter.tryAcquire()) {
            int thisCapacity = this.capacity.getAsInt();
            if (thisCapacity <= 0) {
                thisCapacity = Integer.MAX_VALUE;
            }
            if (thisCapacity != this.queue.getCapacity()) {
                this.queue.setCapacity(thisCapacity);
            }
        }
    }

    @Override
    public boolean add(E e) {
        this.tryCheckCapacity();
        return this.queue.add(e);
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public E remove() {
        return this.queue.remove();
    }

    @Override
    public E element() {
        return this.queue.element();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.tryCheckCapacity();
        return this.queue.addAll(c);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public void put(E o) throws InterruptedException {
        this.tryCheckCapacity();
        this.queue.put(o);
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        this.tryCheckCapacity();
        return this.queue.offer(o, timeout, unit);
    }

    @Override
    public boolean offer(E o) {
        this.tryCheckCapacity();
        return this.queue.offer(o);
    }

    @Override
    public E take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.poll(timeout, unit);
    }

    @Override
    public E poll() {
        return this.queue.poll();
    }

    @Override
    public E peek() {
        return this.queue.peek();
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    public String toString() {
        return this.queue.toString();
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.queue.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return this.queue.drainTo(c, maxElements);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.queue.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.queue.forEach(action);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.queue.removeIf(filter);
    }
}

