/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.KeyAffinityExecutor;
import com.github.phantomthief.pool.impl.KeyAffinityBuilder;
import com.github.phantomthief.pool.impl.KeyAffinityExecutorForStats;
import com.github.phantomthief.pool.impl.KeyAffinityExecutorImpl;
import com.github.phantomthief.pool.impl.ThreadListeningExecutorService;
import com.github.phantomthief.util.SimpleRateLimiter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class KeyAffinityExecutorBuilder {
    static final Map<KeyAffinityExecutor<?>, KeyAffinityExecutor<?>> ALL_EXECUTORS = new ConcurrentHashMap();
    private final KeyAffinityBuilder<ListeningExecutorService> builder = new KeyAffinityBuilder();
    private boolean usingDynamic = false;
    private boolean shutdownAfterClose = true;

    @Nonnull
    public <K> KeyAffinityExecutor<K> build() {
        if (this.usingDynamic && !this.shutdownAfterClose) {
            throw new IllegalStateException("cannot close shutdown after close when enable dynamic count.");
        }
        if (this.shutdownAfterClose) {
            this.builder.depose(it -> MoreExecutors.shutdownAndAwaitTermination((ExecutorService)it, (long)1L, (TimeUnit)TimeUnit.DAYS));
        }
        this.builder.ensure();
        KeyAffinityExecutorImpl result = new KeyAffinityExecutorImpl(this.builder::buildInner);
        ALL_EXECUTORS.put(result, KeyAffinityExecutorForStats.wrapStats(result));
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder shutdownExecutorAfterClose(boolean value) {
        this.shutdownAfterClose = value;
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder usingRandom(boolean value) {
        this.builder.usingRandom(value);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder usingRandom(IntPredicate value) {
        this.builder.usingRandom(value);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder executor(@Nonnull Supplier<ExecutorService> factory) {
        Preconditions.checkNotNull(factory);
        this.builder.factory(() -> {
            ExecutorService executor = (ExecutorService)factory.get();
            if (executor instanceof ListeningExecutorService) {
                return (ListeningExecutorService)executor;
            }
            if (executor instanceof ThreadPoolExecutor) {
                return new ThreadListeningExecutorService((ThreadPoolExecutor)executor);
            }
            return MoreExecutors.listeningDecorator((ExecutorService)executor);
        });
        return this;
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder count(int count) {
        return this.parallelism(count);
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder parallelism(int value) {
        this.builder.count(value);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    @VisibleForTesting
    KeyAffinityExecutorBuilder counterChecker(BooleanSupplier value) {
        this.builder.counterChecker(value);
        return this;
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder count(IntSupplier count) {
        return this.parallelism(count);
    }

    @CheckReturnValue
    @Nonnull
    public KeyAffinityExecutorBuilder parallelism(IntSupplier count) {
        this.builder.count(count);
        this.usingDynamic = true;
        SimpleRateLimiter rateLimiter = SimpleRateLimiter.create(1.0);
        this.builder.counterChecker(rateLimiter::tryAcquire);
        return this;
    }

    public static Collection<KeyAffinityExecutor<?>> getAllExecutors() {
        return Collections.unmodifiableCollection(ALL_EXECUTORS.values());
    }

    @VisibleForTesting
    static void clearAllExecutors() {
        ALL_EXECUTORS.clear();
    }
}

