/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.KeyAffinity;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyAffinityImpl<K, V>
implements KeyAffinity<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(KeyAffinityImpl.class);
    private static long sleepBeforeClose = TimeUnit.SECONDS.toMillis(5L);
    private final IntSupplier count;
    private final List<ValueRef> all;
    private final ThrowableConsumer<V, Exception> deposeFunc;
    private final Map<K, KeyRef> mapping = new ConcurrentHashMap<K, KeyRef>();
    private final IntPredicate usingRandom;
    private final BooleanSupplier counterChecker;
    private final Supplier<V> supplier;

    KeyAffinityImpl(@Nonnull Supplier<V> supplier, IntSupplier count, @Nonnull ThrowableConsumer<V, Exception> deposeFunc, IntPredicate usingRandom, BooleanSupplier counterChecker) {
        this.count = count;
        this.usingRandom = usingRandom;
        this.counterChecker = counterChecker;
        this.supplier = supplier;
        this.all = IntStream.range(0, count.getAsInt()).mapToObj(it -> supplier.get()).map(x$0 -> new ValueRef(x$0)).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        this.deposeFunc = (ThrowableConsumer)Preconditions.checkNotNull(deposeFunc);
    }

    @Nonnull
    public V select(K key) {
        int thisCount = this.count.getAsInt();
        this.tryCheckCount(thisCount);
        KeyRef keyRef = this.mapping.compute(key, (k, v) -> {
            if (v == null) {
                if (this.usingRandom.test(thisCount)) {
                    do {
                        try {
                            v = new KeyRef(this.all.get(ThreadLocalRandom.current().nextInt(this.all.size())));
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    } while (v == null);
                } else {
                    v = this.all.stream().min(Comparator.comparingInt(ValueRef::concurrency)).map(x$0 -> new KeyRef((ValueRef)x$0)).orElseThrow(IllegalStateException::new);
                }
            }
            v.incrConcurrency();
            return v;
        });
        return keyRef.ref();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryCheckCount(int thisCount) {
        if (!this.counterChecker.getAsBoolean()) {
            return;
        }
        int toAdd = thisCount - this.all.size();
        if (toAdd == 0) {
            return;
        }
        KeyAffinityImpl keyAffinityImpl = this;
        synchronized (keyAffinityImpl) {
            toAdd = thisCount - this.all.size();
            if (toAdd > 0) {
                this.all.addAll(IntStream.range(0, toAdd).mapToObj(it -> this.supplier.get()).map(x$0 -> new ValueRef(x$0)).collect(Collectors.toList()));
            } else if (toAdd < 0) {
                ArrayList<ValueRef> toRemove = new ArrayList<ValueRef>();
                for (int i = 0; i < -toAdd; ++i) {
                    if (this.all.size() <= 0) continue;
                    ValueRef remove = this.all.remove(this.all.size() - 1);
                    toRemove.add(remove);
                }
                new Thread(() -> {
                    if (sleepBeforeClose > 0L) {
                        Uninterruptibles.sleepUninterruptibly((long)sleepBeforeClose, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                    for (ValueRef remove : toRemove) {
                        this.waitAndClose(remove);
                    }
                }, "key affinity removal:" + toRemove.size()).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitAndClose(ValueRef remove) {
        while (remove.concurrency.get() > 0) {
            List<ValueRef> list = this.all;
            synchronized (list) {
                try {
                    this.all.wait(TimeUnit.SECONDS.toMillis(1L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.deposeFunc.accept(remove.obj);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    public void finishCall(K key) {
        this.mapping.computeIfPresent(key, (k, v) -> {
            if (v.decrConcurrency()) {
                return null;
            }
            return v;
        });
    }

    @Override
    public boolean inited() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        List<ValueRef> list = this.all;
        synchronized (list) {
            while (this.all.stream().anyMatch(it -> ((ValueRef)it).concurrency.get() > 0)) {
                this.all.wait(TimeUnit.SECONDS.toMillis(1L));
            }
        }
        for (ValueRef ref : this.all) {
            this.deposeFunc.accept(ref.obj);
        }
    }

    @Override
    public Iterator<V> iterator() {
        return Iterators.transform(this.all.iterator(), v -> ((ValueRef)v).obj);
    }

    @VisibleForTesting
    static void setSleepBeforeClose(long sleepBeforeClose) {
        KeyAffinityImpl.sleepBeforeClose = sleepBeforeClose;
    }

    private class ValueRef {
        private final V obj;
        private final AtomicInteger concurrency = new AtomicInteger();

        ValueRef(V obj) {
            this.obj = obj;
        }

        int concurrency() {
            return this.concurrency.get();
        }
    }

    private class KeyRef {
        private final ValueRef valueRef;
        private final AtomicInteger concurrency = new AtomicInteger();

        KeyRef(ValueRef valueRef) {
            this.valueRef = valueRef;
        }

        void incrConcurrency() {
            this.concurrency.incrementAndGet();
            this.valueRef.concurrency.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean decrConcurrency() {
            int r = this.concurrency.decrementAndGet();
            int refConcurrency = this.valueRef.concurrency.decrementAndGet();
            if (refConcurrency <= 0) {
                List list = KeyAffinityImpl.this.all;
                synchronized (list) {
                    KeyAffinityImpl.this.all.notifyAll();
                }
            }
            return r <= 0;
        }

        V ref() {
            return this.valueRef.obj;
        }
    }
}

