/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.pool.impl;

import com.github.phantomthief.pool.KeyAffinity;
import com.github.phantomthief.pool.impl.KeyAffinityImpl;
import com.github.phantomthief.util.MoreSuppliers;
import java.util.Iterator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

class LazyKeyAffinity<K, V>
implements KeyAffinity<K, V> {
    private final MoreSuppliers.CloseableSupplier<KeyAffinityImpl<K, V>> factory;

    LazyKeyAffinity(Supplier<KeyAffinityImpl<K, V>> factory) {
        this.factory = MoreSuppliers.lazy(factory, false);
    }

    @Nonnull
    public V select(K key) {
        return this.factory.get().select(key);
    }

    public void finishCall(K key) {
        this.factory.get().finishCall(key);
    }

    @Override
    public boolean inited() {
        return this.factory.isInitialized();
    }

    @Override
    public void close() throws Exception {
        this.factory.tryClose(AutoCloseable::close);
    }

    @Override
    public Iterator<V> iterator() {
        return this.factory.get().iterator();
    }
}

