/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.MoreStreams;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class MoreIterables {
    private MoreIterables() {
        throw new UnsupportedOperationException();
    }

    public static Stream<List<Long>> batchClosedRangeStream(long from, long to, int batch) {
        return MoreStreams.toStream(MoreIterables.batchClosedRange(from, to, batch));
    }

    public static Iterable<List<Long>> batchClosedRange(long from, long to, int batch) {
        Preconditions.checkArgument((batch > 0 ? 1 : 0) != 0);
        if (from == to) {
            return Collections.singleton(Collections.singletonList(from));
        }
        LongStream longStream = from > to ? LongStream.rangeClosed(to, from).map(i -> from + to - i) : LongStream.rangeClosed(from, to);
        return Iterables.partition(longStream.boxed()::iterator, (int)batch);
    }

    public static Stream<Range<Long>> batchClosedSimpleRangeStream(long from, long to, int batch) {
        return MoreStreams.toStream(MoreIterables.batchClosedSimpleRange(from, to, batch));
    }

    public static Iterable<Range<Long>> batchClosedSimpleRange(final long from, final long to, final int batch) {
        Preconditions.checkArgument((batch > 0 ? 1 : 0) != 0);
        if (from == to) {
            return Collections.singleton(Range.closed((Comparable)Long.valueOf(from), (Comparable)Long.valueOf(to)));
        }
        final boolean reversed = from > to;
        return () -> new Iterator<Range<Long>>(){
            private Range current;
            {
                this.current = reversed ? Range.closed((Comparable)Long.valueOf(Math.max(from - (long)batch, to) + 1L), (Comparable)Long.valueOf(from)) : Range.closed((Comparable)Long.valueOf(from), (Comparable)Long.valueOf(Math.min((long)batch + from, to) - 1L));
            }

            @Override
            public boolean hasNext() {
                return this.current != null && !this.current.isEmpty();
            }

            @Override
            public Range<Long> next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Range result = this.current;
                this.calcNext();
                return result;
            }

            private void calcNext() {
                if (this.current.isEmpty()) {
                    this.current = null;
                    return;
                }
                long newStart = reversed ? (Long)this.current.lowerEndpoint() - 1L : (Long)this.current.upperEndpoint() + 1L;
                if (!reversed && newStart > to || reversed && to > newStart) {
                    this.current = null;
                    return;
                }
                long newEnd = reversed ? Math.max(to, newStart - (long)batch + 1L) : Math.min(to, newStart + (long)batch - 1L);
                this.current = reversed ? Range.closed((Comparable)Long.valueOf(newEnd), (Comparable)Long.valueOf(newStart)) : Range.closed((Comparable)Long.valueOf(newStart), (Comparable)Long.valueOf(newEnd));
            }
        };
    }
}

