/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public final class MoreLocks {
    private MoreLocks() {
        throw new UnsupportedOperationException();
    }

    public static <X extends Throwable> void runWithLock(Lock lock, ThrowableRunnable<X> runnable) throws X {
        MoreLocks.supplyWithLock(lock, MoreLocks.wrapAsRunnable(runnable));
    }

    public static <T, X extends Throwable> T supplyWithLock(Lock lock, ThrowableSupplier<T, X> supplier) throws X {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            lock.unlock();
        }
    }

    public static <X extends Throwable> void runWithTryLock(Lock lock, long time, TimeUnit unit, ThrowableRunnable<X> runnable) throws X, InterruptedException {
        MoreLocks.runWithTryLock(lock, time, unit, runnable, null);
    }

    public static <X extends Throwable> void runWithTryLock(Lock lock, long time, TimeUnit unit, ThrowableRunnable<X> runnable, Runnable withoutAcquiredLock) throws X, InterruptedException {
        MoreLocks.supplyWithTryLock(lock, time, unit, MoreLocks.wrapAsRunnable(runnable), () -> {
            if (withoutAcquiredLock != null) {
                withoutAcquiredLock.run();
            }
            return null;
        });
    }

    public static <T, X extends Throwable> T supplyWithTryLock(Lock lock, long time, TimeUnit unit, ThrowableSupplier<T, X> supplier) throws X, InterruptedException {
        return MoreLocks.supplyWithTryLock(lock, time, unit, supplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithTryLock(Lock lock, long time, TimeUnit unit, ThrowableSupplier<T, X> supplier, Supplier<T> withoutAcquiredLock) throws X, InterruptedException {
        if (lock.tryLock(time, unit)) {
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        if (withoutAcquiredLock != null) {
            return withoutAcquiredLock.get();
        }
        return null;
    }

    public static <X extends Throwable> void runWithTryLock(Lock lock, ThrowableRunnable<X> runnable) throws X {
        MoreLocks.runWithTryLock(lock, runnable, null);
    }

    public static <X extends Throwable> void runWithTryLock(Lock lock, ThrowableRunnable<X> runnable, Runnable withoutAcquiredLock) throws X {
        MoreLocks.supplyWithTryLock(lock, MoreLocks.wrapAsRunnable(runnable), () -> {
            if (withoutAcquiredLock != null) {
                withoutAcquiredLock.run();
            }
            return null;
        });
    }

    public static <T, X extends Throwable> T supplyWithTryLock(Lock lock, ThrowableSupplier<T, X> supplier) throws X {
        return MoreLocks.supplyWithTryLock(lock, supplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithTryLock(Lock lock, ThrowableSupplier<T, X> supplier, Supplier<T> withoutAcquiredLock) throws X {
        if (lock.tryLock()) {
            try {
                T t = supplier.get();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        if (withoutAcquiredLock != null) {
            return withoutAcquiredLock.get();
        }
        return null;
    }

    private static <X extends Throwable> ThrowableSupplier<Void, X> wrapAsRunnable(ThrowableRunnable<X> runnable) {
        return () -> {
            runnable.run();
            return null;
        };
    }
}

