/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MorePredicates {
    private MorePredicates() {
        throw new UnsupportedOperationException();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }

    public static <T> Predicate<T> applyOtherwise(Predicate<T> predicate, Consumer<T> negateConsumer) {
        return t -> {
            boolean result = predicate.test(t);
            if (!result) {
                negateConsumer.accept(t);
            }
            return result;
        };
    }

    public static <T> Predicate<T> distinctUsing(final Function<T, Object> mapper) {
        return new Predicate<T>(){
            private final Set<Object> set = Collections.newSetFromMap(new ConcurrentHashMap());

            @Override
            public boolean test(T t) {
                return this.set.add(mapper.apply(t));
            }
        };
    }

    public static <T> Predicate<T> afterElement(T element) {
        return MorePredicates.afterElement(element, true);
    }

    public static <T> Predicate<T> afterElement(T element, boolean inclusive) {
        return MorePredicates.after(e -> Objects.equals(element, e), inclusive);
    }

    public static <T> Predicate<T> after(Predicate<T> predicate) {
        return MorePredicates.after(predicate, true);
    }

    public static <T> Predicate<T> after(final Predicate<T> predicate, final boolean inclusive) {
        return new Predicate<T>(){
            private boolean started;

            @Override
            public boolean test(T t) {
                if (this.started) {
                    return true;
                }
                if (predicate.test(t)) {
                    this.started = true;
                    if (inclusive) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> probability(final double probability) {
        return new Predicate<T>(){
            private final Random random = new Random();

            @Override
            public boolean test(T t) {
                return this.random.nextDouble() < probability;
            }
        };
    }
}

