/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.tuple.ThreeTuple;
import com.github.phantomthief.tuple.Tuple;
import com.github.phantomthief.util.SimpleRateLimiter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public class RateLogger
implements Logger {
    private static final String FQCN = RateLogger.class.getName();
    private static final double DEFAULT_PERMITS_PER_SECOND = 1.0;
    private static final int MAX_PER_FORMAT_CACHE_SIZE = 100;
    private static final ConcurrentMap<ThreeTuple<String, Double, Boolean>, RateLogger> CACHE = new ConcurrentHashMap<ThreeTuple<String, Double, Boolean>, RateLogger>();
    private final Logger logger;
    private final LocationAwareLogger locationAwareLogger;
    private final SimpleRateLimiter rateLimiter;
    private final LoadingCache<String, SimpleRateLimiter> perFormatStringRateLimiter;

    private RateLogger(Logger logger, final double permitsPerSecond, boolean perFormatString) {
        this.logger = logger;
        this.locationAwareLogger = logger instanceof LocationAwareLogger ? (LocationAwareLogger)logger : null;
        this.perFormatStringRateLimiter = perFormatString ? CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, SimpleRateLimiter>(){

            public SimpleRateLimiter load(String s) {
                return SimpleRateLimiter.create(permitsPerSecond);
            }
        }) : null;
        this.rateLimiter = SimpleRateLimiter.create(permitsPerSecond);
    }

    public static RateLogger rateLogger(Logger logger) {
        return RateLogger.rateLogger(logger, 1.0);
    }

    public static RateLogger perMessageRateLogger(Logger logger) {
        return RateLogger.perMessageRateLogger(logger, 1.0);
    }

    public static RateLogger rateLogger(Logger logger, double permitsPer) {
        return RateLogger.rateLogger(logger, permitsPer, false);
    }

    public static RateLogger perMessageRateLogger(Logger logger, double permitsPer) {
        return RateLogger.rateLogger(logger, permitsPer, true);
    }

    private static RateLogger rateLogger(Logger logger, double permitsPer, boolean perFormatString) {
        String name = logger.getName();
        ThreeTuple<String, Double, Boolean> key = Tuple.tuple(name, permitsPer, perFormatString);
        RateLogger rateLogger = (RateLogger)CACHE.get(key);
        if (rateLogger != null) {
            return rateLogger;
        }
        return CACHE.computeIfAbsent(key, it -> new RateLogger(logger, (Double)it.getSecond(), (Boolean)it.getThird()));
    }

    private SimpleRateLimiter getLimiter(@Nullable String msg) {
        if (this.perFormatStringRateLimiter == null) {
            return this.rateLimiter;
        }
        if (msg == null) {
            return this.rateLimiter;
        }
        return (SimpleRateLimiter)this.perFormatStringRateLimiter.getUnchecked((Object)msg);
    }

    public String getName() {
        return this.logger.getName();
    }

    private String msg(String msg) {
        return "[IGNORED={}]" + msg;
    }

    private Object[] args(SimpleRateLimiter limiter, Object[] args) {
        long skip = limiter.getSkipCountAndClear();
        Object[] result = args == null ? new Object[]{skip} : ArrayUtils.addAll((Object[])new Object[]{skip}, (Object[])args);
        return result;
    }

    private Object[] args(SimpleRateLimiter limiter, Object arg) {
        return this.args(limiter, new Object[]{arg});
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.trace(this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void trace(String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.trace(this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.trace(this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void trace(String format, Object ... arguments) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(format), this.args(limiter, arguments), null);
            } else {
                this.logger.trace(this.msg(format), this.args(limiter, arguments));
            }
        }
    }

    public void trace(String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 0, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.trace(this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.trace(marker, this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.trace(marker, this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.trace(marker, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(format), this.args(limiter, argArray), null);
            } else {
                this.logger.trace(marker, this.msg(format), this.args(limiter, argArray));
            }
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isTraceEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 0, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.trace(marker, this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.debug(this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void debug(String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.debug(this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.debug(this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void debug(String format, Object ... arguments) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(format), this.args(limiter, arguments), null);
            } else {
                this.logger.debug(this.msg(format), this.args(limiter, arguments));
            }
        }
    }

    public void debug(String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 10, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.debug(this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.debug(marker, this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.debug(marker, this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.debug(marker, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void debug(Marker marker, String format, Object ... argArray) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(format), this.args(limiter, argArray), null);
            } else {
                this.logger.debug(marker, this.msg(format), this.args(limiter, argArray));
            }
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isDebugEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 10, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.debug(marker, this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.info(this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void info(String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.info(this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.info(this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void info(String format, Object ... arguments) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(format), this.args(limiter, arguments), null);
            } else {
                this.logger.info(this.msg(format), this.args(limiter, arguments));
            }
        }
    }

    public void info(String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 20, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.info(this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.info(marker, this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void info(Marker marker, String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.info(marker, this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.info(marker, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void info(Marker marker, String format, Object ... argArray) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(format), this.args(limiter, argArray), null);
            } else {
                this.logger.info(marker, this.msg(format), this.args(limiter, argArray));
            }
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isInfoEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 20, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.info(marker, this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.warn(this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void warn(String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.warn(this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.warn(this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void warn(String format, Object ... arguments) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(format), this.args(limiter, arguments), null);
            } else {
                this.logger.warn(this.msg(format), this.args(limiter, arguments));
            }
        }
    }

    public void warn(String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 30, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.warn(this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.warn(marker, this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.warn(marker, this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.warn(marker, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void warn(Marker marker, String format, Object ... argArray) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(format), this.args(limiter, argArray), null);
            } else {
                this.logger.warn(marker, this.msg(format), this.args(limiter, argArray));
            }
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isWarnEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 30, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.warn(marker, this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.error(this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void error(String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.error(this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.error(this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void error(String format, Object ... arguments) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(format), this.args(limiter, arguments), null);
            } else {
                this.logger.error(this.msg(format), this.args(limiter, arguments));
            }
        }
    }

    public void error(String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled() && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(null, FQCN, 40, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.error(this.msg(msg), this.args(limiter, t));
            }
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(msg), this.args(limiter, null), null);
            } else {
                this.logger.error(marker, this.msg(msg), this.args(limiter, null));
            }
        }
    }

    public void error(Marker marker, String format, Object arg) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(format), this.args(limiter, arg), null);
            } else {
                this.logger.error(marker, this.msg(format), this.args(limiter, arg));
            }
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}), null);
            } else {
                this.logger.error(marker, this.msg(format), this.args(limiter, new Object[]{arg1, arg2}));
            }
        }
    }

    public void error(Marker marker, String format, Object ... argArray) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(format)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(format), this.args(limiter, argArray), null);
            } else {
                this.logger.error(marker, this.msg(format), this.args(limiter, argArray));
            }
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        SimpleRateLimiter limiter;
        if (this.isErrorEnabled(marker) && (limiter = this.getLimiter(msg)).tryAcquire()) {
            if (this.locationAwareLogger != null) {
                this.locationAwareLogger.log(marker, FQCN, 40, this.msg(msg), this.args(limiter, null), t);
            } else {
                this.logger.error(marker, this.msg(msg), this.args(limiter, t));
            }
        }
    }
}

