local key = KEYS[1]
local max_count = tonumber(ARGV[1])
local emails = ARGV[2]
local expires_in = tonumber(ARGV[3])
local excludes = {}


-- 检查哈希表是否存在
if redis.call('EXISTS', key) == 0 then
    -- 初始化哈希表并设置过期时间
    redis.call('HSET', key, "1", 1)
    redis.call('EXPIRE', key, expires_in)
end
-- 遍历手机号列表
for email in string.gmatch(emails, "[^,]+") do
    local count = redis.call('HGET', key, email)
    if count and tonumber(count) and tonumber(count) >= max_count then
        table.insert(excludes, email)
    end
end

return table.concat(excludes, ",")
