/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.barcodes;

import com.itextpdf.barcodes.Barcode2D;
import com.itextpdf.barcodes.qrcode.ByteMatrix;
import com.itextpdf.barcodes.qrcode.EncodeHintType;
import com.itextpdf.barcodes.qrcode.QRCodeWriter;
import com.itextpdf.barcodes.qrcode.WriterException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.util.Map;

public class BarcodeQRCode
extends Barcode2D {
    ByteMatrix bm;
    Map<EncodeHintType, Object> hints;
    String code;

    public BarcodeQRCode(String code, Map<EncodeHintType, Object> hints) {
        this.code = code;
        this.hints = hints;
        this.regenerate();
    }

    public BarcodeQRCode(String content) {
        this(content, null);
    }

    public BarcodeQRCode() {
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.regenerate();
    }

    public Map<EncodeHintType, Object> getHints() {
        return this.hints;
    }

    public void setHints(Map<EncodeHintType, Object> hints) {
        this.hints = hints;
        this.regenerate();
    }

    public void regenerate() {
        if (this.code != null) {
            try {
                QRCodeWriter qc = new QRCodeWriter();
                this.bm = qc.encode(this.code, 1, 1, this.hints);
            }
            catch (WriterException ex) {
                throw new IllegalArgumentException(ex.getMessage(), ex.getCause());
            }
        }
    }

    @Override
    public Rectangle getBarcodeSize() {
        return new Rectangle(0.0f, 0.0f, (float)this.bm.getWidth(), (float)this.bm.getHeight());
    }

    public Rectangle getBarcodeSize(float moduleSize) {
        return new Rectangle(0.0f, 0.0f, (float)this.bm.getWidth() * moduleSize, (float)this.bm.getHeight() * moduleSize);
    }

    @Override
    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.color.Color foreground) {
        return this.placeBarcode(canvas, foreground, 1.0f);
    }

    public Rectangle placeBarcode(PdfCanvas canvas, com.itextpdf.kernel.color.Color foreground, float moduleSide) {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        byte[][] mt = this.bm.getArray();
        if (foreground != null) {
            canvas.setFillColor(foreground);
        }
        for (int y = 0; y < height; ++y) {
            byte[] line = mt[y];
            for (int x = 0; x < width; ++x) {
                if (line[x] != 0) continue;
                canvas.rectangle((double)((float)x * moduleSide), (double)((float)(height - y - 1) * moduleSide), (double)moduleSide, (double)moduleSide);
            }
        }
        canvas.fill();
        return this.getBarcodeSize(moduleSide);
    }

    @Override
    public PdfFormXObject createFormXObject(com.itextpdf.kernel.color.Color foreground, PdfDocument document) {
        return this.createFormXObject(foreground, 1.0f, document);
    }

    public PdfFormXObject createFormXObject(com.itextpdf.kernel.color.Color foreground, float moduleSize, PdfDocument document) {
        PdfFormXObject xObject = new PdfFormXObject((Rectangle)null);
        Rectangle rect = this.placeBarcode(new PdfCanvas(xObject, document), foreground, moduleSize);
        xObject.setBBox(new PdfArray(rect));
        return xObject;
    }

    public Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int[] pix = new int[width * height];
        byte[][] mt = this.bm.getArray();
        for (int y = 0; y < height; ++y) {
            byte[] line = mt[y];
            for (int x = 0; x < width; ++x) {
                pix[y * width + x] = line[x] == 0 ? f : g;
            }
        }
        Image img = canvas.createImage(new MemoryImageSource(width, height, pix, 0, width));
        return img;
    }

    private byte[] getBitMatrix() {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int stride = (width + 7) / 8;
        byte[] b = new byte[stride * height];
        byte[][] mt = this.bm.getArray();
        for (int y = 0; y < height; ++y) {
            byte[] line = mt[y];
            for (int x = 0; x < width; ++x) {
                int offset;
                if (line[x] == 0) continue;
                int n = offset = stride * y + x / 8;
                b[n] = (byte)(b[n] | (byte)(128 >> x % 8));
            }
        }
        return b;
    }
}

