/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupElementNode;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutline;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.navigation.PdfDestination;
import com.itextpdf.layout.element.IElement;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutlineHandler {
    private static final String DESTINATION_PREFIX = "pdfHTML-iText-outline-";
    private PdfOutline currentOutline;
    private Deque<String> destinationsInProcess = new LinkedList<String>();
    private Deque<Integer> levelsInProcess = new LinkedList<Integer>();
    private Map<String, Integer> tagPrioritiesMapping = new HashMap<String, Integer>();
    private Map<String, Integer> uniqueIDs = new HashMap<String, Integer>();

    public static OutlineHandler createStandardHandler() {
        OutlineHandler handler = new OutlineHandler();
        handler.putTagPriorityMapping("h1", 1);
        handler.putTagPriorityMapping("h2", 2);
        handler.putTagPriorityMapping("h3", 3);
        handler.putTagPriorityMapping("h4", 4);
        handler.putTagPriorityMapping("h5", 5);
        handler.putTagPriorityMapping("h6", 6);
        return handler;
    }

    public OutlineHandler putTagPriorityMapping(String tagName, Integer priority) {
        this.tagPrioritiesMapping.put(tagName, priority);
        return this;
    }

    public OutlineHandler putAllTagPriorityMappings(Map<String, Integer> mappings) {
        this.tagPrioritiesMapping.putAll(mappings);
        return this;
    }

    public Integer getTagPriorityMapping(String tagName) {
        return this.tagPrioritiesMapping.get(tagName);
    }

    public boolean hasTagPriorityMapping(String tagName) {
        return this.tagPrioritiesMapping.containsKey(tagName);
    }

    public void reset() {
        this.currentOutline = null;
        this.destinationsInProcess.clear();
        this.levelsInProcess.clear();
        this.uniqueIDs.clear();
    }

    OutlineHandler addOutline(ITagWorker tagWorker, IElementNode element, ProcessorContext context) {
        String tagName = element.name();
        if (null != tagWorker && this.hasTagPriorityMapping(tagName)) {
            int level = this.getTagPriorityMapping(tagName);
            if (null == this.currentOutline) {
                this.currentOutline = context.getPdfDocument().getOutlines(false);
            }
            PdfOutline parent = this.currentOutline;
            while (!this.levelsInProcess.isEmpty() && level <= this.levelsInProcess.getFirst()) {
                parent = parent.getParent();
                this.levelsInProcess.pop();
            }
            String content = ((JsoupElementNode)element).text();
            if (content.isEmpty()) {
                content = this.getUniqueID(tagName);
            }
            PdfOutline outline = parent.addOutline(content);
            String destination = DESTINATION_PREFIX + this.getUniqueID(DESTINATION_PREFIX);
            outline.addDestination(PdfDestination.makeDestination((PdfObject)new PdfString(destination)));
            this.destinationsInProcess.push(destination);
            this.levelsInProcess.push(level);
            this.currentOutline = outline;
        }
        return this;
    }

    OutlineHandler addDestination(ITagWorker tagWorker, IElementNode element) {
        String tagName = element.name();
        if (null != tagWorker && this.hasTagPriorityMapping(tagName)) {
            String content = this.destinationsInProcess.pop();
            if (tagWorker.getElementResult() instanceof IElement) {
                tagWorker.getElementResult().setProperty(17, (Object)content);
            } else {
                Logger logger = LoggerFactory.getLogger(OutlineHandler.class);
                logger.warn(MessageFormatUtil.format((String)"Tag worker does not produce IPropertyContainer for \"{0}\" tag. An outline for \"{0}\" tag will not be created.", (Object[])new Object[]{tagName}));
            }
        }
        return this;
    }

    private String getUniqueID(String key) {
        if (!this.uniqueIDs.containsKey(key)) {
            this.uniqueIDs.put(key, 1);
        }
        int id = this.uniqueIDs.get(key);
        this.uniqueIDs.put(key, id + 1);
        return key + id;
    }
}

