/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class NameConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_nameConstraints;
    private Vector permitted;
    private Vector excluded;

    public NameConstraintsExtension() {
        super(TYPE);
    }

    public NameConstraintsExtension(Vector permitted, Vector excluded) {
        this(permitted, excluded, true);
    }

    public NameConstraintsExtension(Vector permitted, Vector excluded, boolean critical) {
        super(TYPE, critical);
        this.permitted = permitted;
        this.excluded = excluded;
        this.setValue(this.toByteArray());
    }

    public NameConstraintsExtension(InputStream is) throws IOException {
        super(is);
    }

    public Vector getPermittedSubtrees() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.permitted;
    }

    public Vector getExcludedSubtrees() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.excluded;
    }

    public void addPermittedSubtree(GeneralName name) {
        if (this.permitted == null) {
            this.permitted = new Vector();
        }
        this.permitted.addElement(name);
        this.setValue(this.toByteArray());
    }

    public void addExcludedSubtree(GeneralName name) {
        if (this.excluded == null) {
            this.excluded = new Vector();
        }
        this.excluded.addElement(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1Sequence s;
        int i;
        int len;
        ASN1Sequence nameCons = new ASN1Sequence();
        if (this.permitted != null && this.permitted.size() > 0) {
            ASN1GenericConstructed perm = new ASN1GenericConstructed(0);
            len = this.permitted.size();
            for (i = 0; i < len; ++i) {
                s = new ASN1Sequence();
                s.addElement((ASN1Object)((GeneralName)this.permitted.elementAt(i)));
                perm.addElement((ASN1Object)s);
            }
            nameCons.addElement((ASN1Object)perm);
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            ASN1GenericConstructed excl = new ASN1GenericConstructed(1);
            len = this.excluded.size();
            for (i = 0; i < len; ++i) {
                s = new ASN1Sequence();
                s.addElement((ASN1Object)((GeneralName)this.excluded.elementAt(i)));
                excl.addElement((ASN1Object)s);
            }
            nameCons.addElement((ASN1Object)excl);
        }
        byte[] b = Utils.toBytes((Streamable)nameCons);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ASN1Sequence s;
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream permis = new ASN1SequenceInputStream((InputStream)sis);
                this.permitted = new Vector();
                while (permis.hasMoreData()) {
                    s = new ASN1Sequence((InputStream)permis);
                    this.permitted.addElement(new GeneralName(Utils.toStream((Streamable)s.elementAt(0))));
                }
                permis.terminate();
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream exclis = new ASN1SequenceInputStream((InputStream)sis);
                this.excluded = new Vector();
                while (exclis.hasMoreData()) {
                    s = new ASN1Sequence((InputStream)exclis);
                    this.excluded.addElement(new GeneralName(Utils.toStream((Streamable)s.elementAt(0))));
                }
                exclis.terminate();
            }
            sis.terminate();
            if (this.permitted == null && this.excluded == null) {
                throw new ASN1FormatException("No name constraints defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    public String toString() {
        int i;
        int size;
        boolean mid;
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("nameConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getPermittedSubtrees() != null) {
            s.append("permitted = {");
            mid = false;
            size = this.getPermittedSubtrees().size();
            for (i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((GeneralName)this.getPermittedSubtrees().elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
            began = true;
        }
        if (this.getExcludedSubtrees() != null) {
            if (began) {
                s.append(", ");
            }
            s.append("excluded = {");
            mid = false;
            size = this.getExcludedSubtrees().size();
            for (i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(((GeneralName)this.getExcludedSubtrees().elementAt(i)).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

