package com.simm.exhibitor.dto.shipment;

import com.alibaba.excel.annotation.write.style.ContentStyle;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Jone Ying
 * @since 2021/8/11
 **/
@Data
public class SettlementDto implements Serializable {

    //展位号
    private String booth;

    //参展商公司名称
    private String comFullName;

    //联系人
    private String contactName;

    //联系电话
    private String contactMobile;

    //操作时间
    private String workDate;

    //裸机进&出馆
    @ContentStyle(dataFormat = 2)
    private double exhibitorIn1;
    @ContentStyle(dataFormat = 2)
    private double exhibitorOut1;

    //带包装进&出馆
    @ContentStyle(dataFormat = 2)
    private double exhibitorIn2;
    @ContentStyle(dataFormat = 2)
    private double exhibitorOut2;

    //按重量进&出馆(模具、钢材类)
    @ContentStyle(dataFormat = 2)
    private double exhibitorIn3;
    @ContentStyle(dataFormat = 2)
    private double exhibitorOut3;

    //展品进&出馆超重附加费
    @ContentStyle(dataFormat = 2)
    private double overweightIn1;
    @ContentStyle(dataFormat = 2)
    private double overweightOut1;

    @ContentStyle(dataFormat = 2)
    private double overweightIn2;
    @ContentStyle(dataFormat = 2)
    private double overweightOut2;

    @ContentStyle(dataFormat = 2)
    private double overweightIn3;
    @ContentStyle(dataFormat = 2)
    private double overweightOut3;

    //展品进&出馆超限附加费
    @ContentStyle(dataFormat = 2)
    private double voerrunIn;
    @ContentStyle(dataFormat = 2)
    private double voerrunOut;

    //叉车、吊车租赁服务
    private int forklift3;
    private int forklift5;
    private int forklift8;
    private int forklift12;
    private int forklift15;

    private int crane8;
    private int crane25;
    private int crane50;
    private int craneOther;

    //二次移位服务
    private int quadraticShift;
    private int mechanicalArm;

    //包装存储费
    @ContentStyle(dataFormat = 2)
    private double packageSum;
    private int packageDays;

    //收款信息
    private String receiptBusinessName;
    private String receiptBank;
    private String receiptBankAccount;

    //总金额
    private String discountText = "";
    @ContentStyle(dataFormat = 2)
    private Double discount;
    private String amountText = "";
    @ContentStyle(dataFormat = 2)
    private Double amount;
}
