package com.simm.exhibitor.vo.basic;

import com.simm.common.vo.BaseVO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author Yingjianghua
 * @version v1.0
 *  MenuButtonConfigurationVO
 * 
 * @since 2019/1/15 9:56
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class MenuButtonConfigurationVO extends BaseVO {

    @ApiModelProperty("菜单id（smeb_auth.id）")
    private Integer menuId;

    @ApiModelProperty("按钮配置（1：配置下载链接，2：配置重要提示，3：配置页面内容，4：配置字段内容）")
    private Integer buttonConfiguration;

    @ApiModelProperty("按钮配置内容（下载链接已json格式存储，静态内容存样式标签跟文本）")
    private String content;

    @ApiModelProperty("按钮配置英文内容（下载链接已json格式存储，静态内容存样式标签跟文本）")
    private String contentEn;

}
