package com.simm.exhibitor.bean.exhibits;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
* Created by Mybatis Generator on 2019/12/17 14:40
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebExhibitApplicationIndustry extends BaseBean {
    @ApiModelProperty("")
    private Integer id;

    @ApiModelProperty("名称")
    @NotBlank(message = "中文名称不能为空")
    private String name;

    @ApiModelProperty("")
    @NotBlank(message = "英文名称不能为空")
    private String nameEn;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("状态(1:正常，-1:异常)")
    private Integer status;

    @ApiModelProperty("年份")
    @NotNull(message = "年份不能为空")
    private Integer year;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;
}