package com.simm.exhibitor.bean.workContent;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
* Created by Mybatis Generator on 2019/02/27 10:56
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class SmebWorksheet extends BaseBean {
    @ApiModelProperty("主键id")
    private Integer id;

    @ApiModelProperty("条目名称")
    private String entryName;

    @ApiModelProperty("条目名称英文")
    private String entryNameEn;

    @ApiModelProperty("条目类型（1：网址，2:上传文档，3：弹出框文字说明）")
    private Integer entryType;

    @ApiModelProperty("服务类型（1：展位费用，2:展商资料，3：服务预订，4：上传位置图，5：申领展商证，6：标准展位搭建申报，7：用电安全承诺书，8：非深蓝牌车通行证申请，9：黄牌车通行证申请，10展品申报，11：台湾展品报关）")
    private Integer serviceType;

    @ApiModelProperty("条目附件")
    private String entryAttachment;

    @ApiModelProperty("")
    private String entryAttachmentEn;

    @ApiModelProperty("条目描述")
    private String entryDescribe;

    @ApiModelProperty("条目描述英文")
    private String entryDescribeEn;

    @ApiModelProperty("截止时间类型（1：选择框，2：文本）")
    private Integer expireDateType;

    @ApiModelProperty("截止时间")
    private Date expireDate;

    @ApiModelProperty("截止时间文本方式")
    private String expireDateText;

    @ApiModelProperty("截止时间文本方式英文")
    private String expireDateTextEn;

    @ApiModelProperty("对应展商")
    private String faceExhibitor;

    @ApiModelProperty("对应展商英文")
    private String faceExhibitorEn;

    @ApiModelProperty("必需完成（0：否，1：是）")
    private Integer isNecessary;

    @ApiModelProperty("是否短信提醒条目信息（0：否，1：是）")
    private Integer isSmsNotice;

    @ApiModelProperty("提醒内容")
    private String noticeContent;

    @ApiModelProperty("提醒时间")
    private Date noticeTime;

    @ApiModelProperty("排序")
    private Integer sorting;

    @ApiModelProperty("是否置顶（0：否，1：是）")
    private Integer isTop;

    @ApiModelProperty("状态(1:正常,-1:异常)")
    private Integer status;

    //冗余字段
    private List<Integer> roleIds;

    private List<SmebRoleWorksheet> roleWorksheetList;

}