package com.simm.exhibitor.bean.basic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Yingjianghua
 * @version v1.0
 *  ExhibitorInfoDto
 * 
 * @since 2019/1/18 14:10
 */
@Data
@ApiModel("展位信息")
public class ExhibitorBooth implements Serializable {

    private static final long serialVersionUID = -3275949953203283578L;

    @ApiModelProperty("展商id（smdm_exhibitor_baseinfo.id）")
    private Integer exhibitorBaseinfoId;

    @ApiModelProperty("届数")
    private Integer number;

    @ApiModelProperty("老展位号")
    private String oldBoothNo;

    @ApiModelProperty("展馆id")
    private String boothId;

    @ApiModelProperty("新展位号")
    private String boothNo;

    @ApiModelProperty("展位面积")
    private String boothArea;

    @ApiModelProperty("展位类型")
    private Integer boothType;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("唯一id 用来区分没有展商id的账号信息")
    private String uniqueId;

    @ApiModelProperty("收款账户")
    private String receiptBankAccount;

    @ApiModelProperty("收款账户 英文")
    private String receiptBankAccountEn;

    @ApiModelProperty("开户行")
    private String bank;

    @ApiModelProperty("开户行 英文")
    private String bankEn;

    @ApiModelProperty("帐号")
    private String accounts;

    @ApiModelProperty("帐号 英文")
    private String accountsEn;
}
