package com.simm.exhibitor.bean.shipment;

import com.simm.common.bean.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
* Created by Mybatis Generator on 2024/08/01 15:17
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class ShipmentOrder extends BaseBean {
    /**
     * id
     */
    private Integer id;

    /**
     * 展商uniqueId
     */
    private String uniqueId;
    /**
     * 订单编号
     */
    private String orderNo;
    /**
     * 作业日期
     */
    private String workDate;
    /**
     * 车牌号
     */
    private String carNo;

    /**
     * 订单金额
     */
    private Integer amount;

    /**
     * 实际金额
     */
    private Integer actualAmount;

    /**
     * 已领金额
     */
    private Integer paidAmount;

    /**
     * 进出馆金额
     */
    private Integer transportAmount;

    /**
     * 超限金额
     */
    private Integer overrunAmount;

    /**
     * 包装存储金额
     */
    private Integer packageAmount;

    /**
     * 原价超重金额
     */
    private Integer originOverweightAmount;

    /**
     * 超重金额
     */
    private Integer overweightAmount;

    /**
     * 原价包装存储金额
     */
    private Integer originPackageAmount;

    /**
     * 原价超限金额
     */
    private Integer originOverrunAmount;

    /**
     * 原价进出馆金额
     */
    private Integer originTransportAmount;

    /**
     * 原价申报服务金额
     */
    private Integer originServiceAmount;

    /**
     * 复核服务金额
     */
    private Integer serviceAmount;
    /**
     * 原价空箱搬运金额(单位：分)
     */
    private Integer originEmptyContainerAmount;
    /**
     * 空箱搬运金额(单位：分)
     */
    private Integer emptyContainerAmount;

    /**
     * 其它优惠金额
     */
    private Integer discountAmount;

    /**
     * 追加优惠金额
     */
    private Integer appendDiscountAmount;
    /**
     * 订单状态(1:未付款,2:付部分款,3:已付清)
     */
    private Integer orderStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 最后更新时间
     */
    private Date lastUpdateTime;

    /**
     * 打印状态 0 未打印 1 已打印
     */
    private Integer printStatus;

    /**
     * "0 不紧急开票 1 紧急开票
     */
    private Integer urgentInvoice;

    /**
     * 1 未开票 2 已开票
     */
    private Integer openInvoice;

    /**
     * 1:未申请,2:新申请,3:已申请
     */
    private Integer invoiceApply;

    /**
     * 已开票金额
     */
    private Integer openInvoiceAmount;

     /**
     * 小程序二维码
     */
    private String miniQrCodeUrl;
}