/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.multiplex;

import java.nio.channels.AsynchronousChannelGroup;
import java.util.ArrayList;
import java.util.List;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.extension.plugins.Plugin;

public class MultiplexOptions<T> {
    private AsynchronousChannelGroup group;
    private int connectTimeout;
    private int idleTimeout = 60000;
    private int readBufferSize = 1024;
    private int writeChunkSize = 1024;
    private int writeChunkCount = 16;
    private String host;
    private int port;
    private boolean ssl;
    private int maxConnections = 128;
    private int minConnections = 0;
    private BufferPagePool readBufferPool;
    private BufferPagePool writeBufferPool;
    private final List<Plugin<T>> plugins = new ArrayList<Plugin<T>>();

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    String getHost() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    boolean isSsl() {
        return this.ssl;
    }

    List<Plugin<T>> getPlugins() {
        return this.plugins;
    }

    public MultiplexOptions<T> addPlugin(Plugin<T> plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public MultiplexOptions<T> group(AsynchronousChannelGroup group) {
        this.group = group;
        return this;
    }

    public AsynchronousChannelGroup group() {
        return this.group;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public MultiplexOptions<T> connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    int idleTimeout() {
        return this.idleTimeout;
    }

    public MultiplexOptions<T> idleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    int getMaxConnections() {
        return this.maxConnections;
    }

    public MultiplexOptions<T> maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    int getMinConnections() {
        return this.minConnections;
    }

    public MultiplexOptions<T> minConnections(int minConnections) {
        this.minConnections = minConnections;
        return this;
    }

    public void setWriteBuffer(int chunkSize, int chunkCount) {
        this.writeChunkSize = chunkSize;
        this.writeChunkCount = chunkCount;
    }

    public void setReadBuffer(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    int getIdleTimeout() {
        return this.idleTimeout;
    }

    int getReadBufferSize() {
        return this.readBufferSize;
    }

    int getWriteChunkSize() {
        return this.writeChunkSize;
    }

    int getWriteChunkCount() {
        return this.writeChunkCount;
    }

    BufferPagePool getReadBufferPool() {
        return this.readBufferPool;
    }

    BufferPagePool getWriteBufferPool() {
        return this.writeBufferPool;
    }

    public MultiplexOptions<T> setBufferPool(BufferPagePool readBufferPool, BufferPagePool writeBufferPool) {
        this.readBufferPool = readBufferPool;
        this.writeBufferPool = writeBufferPool;
        return this;
    }
}

