/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.plugins;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.smartboot.socket.channels.AsynchronousSocketChannelProxy;
import org.smartboot.socket.channels.UnsupportedAsynchronousSocketChannel;
import org.smartboot.socket.extension.plugins.AbstractPlugin;

public class StreamMonitorPlugin<T>
extends AbstractPlugin<T> {
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> BLUE_HEX_INPUT_STREAM = (channel, bytes) -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            System.out.println("\u001b[34m" + simpleDateFormat.format(new Date()) + " [ " + channel.getRemoteAddress() + " --> " + channel.getLocalAddress() + " ] [ read: " + ((byte[])bytes).length + " bytes ]" + StreamMonitorPlugin.toHexString(bytes) + "\u001b[0m");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> RED_HEX_OUTPUT_STREAM = (channel, bytes) -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            System.out.println("\u001b[31m" + simpleDateFormat.format(new Date()) + " [ " + channel.getLocalAddress() + " --> " + channel.getRemoteAddress() + " ] [ write: " + ((byte[])bytes).length + " bytes ]" + StreamMonitorPlugin.toHexString(bytes) + "\u001b[0m");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> BLUE_TEXT_INPUT_STREAM = (channel, bytes) -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            System.out.println("\u001b[34m" + simpleDateFormat.format(new Date()) + " [ " + channel.getRemoteAddress() + " --> " + channel.getLocalAddress() + " ] [ read: " + ((byte[])bytes).length + " bytes ]\r\n" + new String((byte[])bytes) + "\u001b[0m");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    public static final BiConsumer<AsynchronousSocketChannel, byte[]> RED_TEXT_OUTPUT_STREAM = (channel, bytes) -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            System.out.println("\u001b[31m" + simpleDateFormat.format(new Date()) + " [ " + channel.getLocalAddress() + " --> " + channel.getRemoteAddress() + " ] [ write: " + ((byte[])bytes).length + " bytes ]\r\n" + new String((byte[])bytes) + "\u001b[0m");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    };
    private final BiConsumer<AsynchronousSocketChannel, byte[]> inputStreamConsumer;
    private final BiConsumer<AsynchronousSocketChannel, byte[]> outputStreamConsumer;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final int TWO = 2;

    public StreamMonitorPlugin() {
        this(BLUE_HEX_INPUT_STREAM, RED_HEX_OUTPUT_STREAM);
    }

    public StreamMonitorPlugin(BiConsumer<AsynchronousSocketChannel, byte[]> inputStreamConsumer, BiConsumer<AsynchronousSocketChannel, byte[]> outputStreamConsumer) {
        this.inputStreamConsumer = Objects.requireNonNull(inputStreamConsumer);
        this.outputStreamConsumer = Objects.requireNonNull(outputStreamConsumer);
    }

    @Override
    public AsynchronousSocketChannel shouldAccept(AsynchronousSocketChannel channel) {
        return new StreamMonitorAsynchronousSocketChannel(channel);
    }

    private static String toHex(byte b) {
        char[] buf = new char[2];
        for (int i = 0; i < buf.length; ++i) {
            buf[1 - i] = DIGITS[b & 0xF];
            b = (byte)(b >>> 4);
        }
        return new String(buf);
    }

    private static String toHexString(byte[] bytes) {
        int i;
        StringBuilder buffer = new StringBuilder(bytes.length);
        buffer.append("\r\n\t\t   0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f\r\n");
        int startIndex = 0;
        int column = 0;
        block4: for (i = 0; i < bytes.length; ++i) {
            column = i % 16;
            switch (column) {
                case 0: {
                    startIndex = i;
                    buffer.append(StreamMonitorPlugin.fixHexString(Integer.toHexString(i), 8)).append(": ");
                    buffer.append(StreamMonitorPlugin.toHex(bytes[i]));
                    buffer.append(' ');
                    continue block4;
                }
                case 15: {
                    buffer.append(StreamMonitorPlugin.toHex(bytes[i]));
                    buffer.append(" ; ");
                    buffer.append(StreamMonitorPlugin.filterString(bytes, startIndex, column + 1));
                    buffer.append("\r\n");
                    continue block4;
                }
                default: {
                    buffer.append(StreamMonitorPlugin.toHex(bytes[i]));
                    buffer.append(' ');
                }
            }
        }
        if (column != 15) {
            for (i = 0; i < 15 - column; ++i) {
                buffer.append("   ");
            }
            buffer.append("; ").append(StreamMonitorPlugin.filterString(bytes, startIndex, column + 1));
            buffer.append("\r\n");
        }
        return buffer.toString();
    }

    private static String filterString(byte[] bytes, int offset, int count) {
        byte[] buffer = new byte[count];
        System.arraycopy(bytes, offset, buffer, 0, count);
        for (int i = 0; i < count; ++i) {
            if (buffer[i] < 0 || buffer[i] > 31) continue;
            buffer[i] = 46;
        }
        return new String(buffer);
    }

    private static String fixHexString(String hexStr, int length) {
        if (hexStr == null || hexStr.length() == 0) {
            return "00000000h";
        }
        StringBuilder buf = new StringBuilder(length);
        int strLen = hexStr.length();
        for (int i = 0; i < length - strLen; ++i) {
            buf.append('0');
        }
        buf.append(hexStr).append('h');
        return buf.toString();
    }

    class StreamMonitorAsynchronousSocketChannel
    extends AsynchronousSocketChannelProxy {
        public StreamMonitorAsynchronousSocketChannel(AsynchronousSocketChannel asynchronousSocketChannel) {
            super(asynchronousSocketChannel);
        }

        @Override
        public <A> void read(ByteBuffer dst, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.read(dst, timeout, unit, attachment, new MonitorCompletionHandler<A>(this, handler, StreamMonitorPlugin.this.inputStreamConsumer, dst));
        }

        @Override
        public <A> void write(ByteBuffer src, long timeout, TimeUnit unit, A attachment, CompletionHandler<Integer, ? super A> handler) {
            super.write(src, timeout, unit, attachment, new MonitorCompletionHandler<A>(this, handler, StreamMonitorPlugin.this.outputStreamConsumer, src));
        }

        @Override
        public Future<Integer> read(final ByteBuffer dst) {
            final Future<Integer> future = super.read(dst);
            return new Future<Integer>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return future.cancel(mayInterruptIfRunning);
                }

                @Override
                public boolean isCancelled() {
                    return future.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return future.isDone();
                }

                @Override
                public Integer get() throws InterruptedException, ExecutionException {
                    int result = (Integer)future.get();
                    if (result > 0) {
                        byte[] bytes = new byte[result];
                        dst.position(dst.position() - result);
                        dst.get(bytes);
                        StreamMonitorPlugin.this.inputStreamConsumer.accept(StreamMonitorAsynchronousSocketChannel.this, bytes);
                    }
                    return result;
                }

                @Override
                public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    int result = (Integer)future.get(timeout, unit);
                    if (result > 0) {
                        byte[] bytes = new byte[result];
                        dst.position(dst.position() - result);
                        dst.get(bytes);
                        StreamMonitorPlugin.this.inputStreamConsumer.accept(StreamMonitorAsynchronousSocketChannel.this, bytes);
                    }
                    return result;
                }
            };
        }
    }

    static class ConsoleColors {
        public static final String RESET = "\u001b[0m";
        public static final String BLUE = "\u001b[34m";
        public static final String RED = "\u001b[31m";

        ConsoleColors() {
        }
    }

    static class MonitorCompletionHandler<A>
    implements CompletionHandler<Integer, A> {
        CompletionHandler<Integer, A> handler;
        BiConsumer<AsynchronousSocketChannel, byte[]> consumer;
        ByteBuffer buffer;
        AsynchronousSocketChannel channel;

        public MonitorCompletionHandler(final AsynchronousSocketChannel channel, CompletionHandler<Integer, A> handler, BiConsumer<AsynchronousSocketChannel, byte[]> consumer, ByteBuffer buffer) {
            this.channel = new UnsupportedAsynchronousSocketChannel(channel){

                @Override
                public SocketAddress getRemoteAddress() throws IOException {
                    return channel.getRemoteAddress();
                }

                @Override
                public SocketAddress getLocalAddress() throws IOException {
                    return channel.getLocalAddress();
                }
            };
            this.handler = handler;
            this.consumer = consumer;
            this.buffer = buffer;
        }

        @Override
        public void completed(Integer result, A attachment) {
            if (result > 0) {
                byte[] bytes = new byte[result.intValue()];
                this.buffer.position(this.buffer.position() - result);
                this.buffer.get(bytes);
                this.consumer.accept(this.channel, bytes);
            }
            this.handler.completed(result, attachment);
        }

        @Override
        public void failed(Throwable exc, A attachment) {
            this.handler.failed(exc, attachment);
        }
    }
}

