/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.extension.ssl.factory;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.smartboot.socket.extension.ssl.factory.SSLContextFactory;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class AutoServerSSLContextFactory
implements SSLContextFactory {
    private final String commonName;
    private final String organization;
    private final String organizationalUnit;
    private final int validityDays;
    private final String keyAlgorithm;
    private final int keySize;

    AutoServerSSLContextFactory(String commonName, String organization, String organizationalUnit, int validityDays, String keyAlgorithm, int keySize) {
        this.commonName = commonName;
        this.organization = organization;
        this.organizationalUnit = organizationalUnit;
        this.validityDays = validityDays;
        this.keyAlgorithm = keyAlgorithm;
        this.keySize = keySize;
    }

    public AutoServerSSLContextFactory() {
        this("localhost", "smartboot", "smart-socket", 365, "RSA", 2048);
    }

    @Override
    public SSLContext create() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyAlgorithm);
        keyPairGenerator.initialize(this.keySize, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate certificate = this.generateSelfSignedCertificate(keyPair);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        Certificate[] chain = new Certificate[]{certificate};
        keyStore.setKeyEntry("server", privateKey, new char[0], chain);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, new char[0]);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagerFactory.getKeyManagers(), null, new SecureRandom());
        return sslContext;
    }

    @Override
    public void initSSLEngine(SSLEngine sslEngine) {
        sslEngine.setUseClientMode(false);
    }

    private X509Certificate generateSelfSignedCertificate(KeyPair keyPair) throws Exception {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("version", new CertificateVersion(2));
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        AlgorithmId algo = new AlgorithmId(AlgorithmId.sha256WithRSAEncryption_oid);
        certInfo.set("algorithmID", new CertificateAlgorithmId(algo));
        long currentTime = System.currentTimeMillis();
        Date from = new Date(currentTime);
        Date to = new Date(currentTime + (long)this.validityDays * 24L * 60L * 60L * 1000L);
        CertificateValidity interval = new CertificateValidity(from, to);
        certInfo.set("validity", interval);
        String dn = "CN=" + this.commonName + ", O=" + this.organization + ", OU=" + this.organizationalUnit;
        X500Name owner = new X500Name(dn);
        certInfo.set("subject", owner);
        certInfo.set("issuer", owner);
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        CertificateExtensions extensions = new CertificateExtensions();
        extensions.set("BasicConstraints", new BasicConstraintsExtension(true, -1));
        boolean[] keyUsage = new boolean[9];
        keyUsage[0] = true;
        keyUsage[2] = true;
        keyUsage[5] = true;
        extensions.set("KeyUsage", new KeyUsageExtension(keyUsage));
        GeneralNames generalNames = new GeneralNames();
        generalNames.add(new GeneralName(new DNSName(this.commonName)));
        extensions.set("SubjectAlternativeName", new SubjectAlternativeNameExtension(generalNames));
        certInfo.set("extensions", extensions);
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), "SHA256withRSA");
        return cert;
    }
}

