/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.UdpChannel;
import org.smartboot.socket.transport.WriteBuffer;
import org.smartboot.socket.transport.WriteBufferImpl;

final class UdpAioSession
extends AioSession {
    private final UdpChannel udpChannel;
    private final SocketAddress remote;
    final WriteBufferImpl byteBuf;

    UdpAioSession(UdpChannel udpChannel, SocketAddress remote, BufferPagePool pool) {
        this.udpChannel = udpChannel;
        this.remote = remote;
        this.byteBuf = new WriteBufferImpl(pool, buffer -> udpChannel.write((VirtualBuffer)buffer, this), udpChannel.config.getWriteChunkSize(), 1);
        udpChannel.config.getProcessor().stateEvent((AioSession)this, StateMachineEnum.NEW_SESSION, null);
    }

    public WriteBuffer writeBuffer() {
        return this.byteBuf;
    }

    public ByteBuffer readBuffer() {
        throw new UnsupportedOperationException();
    }

    public void awaitRead() {
        throw new UnsupportedOperationException();
    }

    public void signalRead() {
        throw new UnsupportedOperationException();
    }

    public void close(boolean immediate) {
        this.byteBuf.flush();
    }

    public InetSocketAddress getLocalAddress() throws IOException {
        return (InetSocketAddress)this.udpChannel.getChannel().getLocalAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.remote;
    }
}

