/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.UdpAioSession;
import org.smartboot.socket.transport.Worker;

public final class UdpChannel {
    private final BufferPagePool writeBufferPage;
    private ConcurrentLinkedQueue<ResponseUnit> responseTasks;
    private Worker worker;
    final IoServerConfig config;
    private final DatagramChannel channel;
    private SelectionKey selectionKey;
    private ResponseUnit failResponseUnit;

    UdpChannel(DatagramChannel channel, IoServerConfig config, BufferPagePool writeBufferPage) {
        this.channel = channel;
        this.writeBufferPage = writeBufferPage;
        this.config = config;
    }

    UdpChannel(DatagramChannel channel, Worker worker, IoServerConfig config, BufferPagePool writeBufferPage) {
        this(channel, config, writeBufferPage);
        this.responseTasks = new ConcurrentLinkedQueue();
        this.worker = worker;
        worker.addRegister(selector -> {
            try {
                this.selectionKey = channel.register((Selector)selector, 1, this);
            }
            catch (ClosedChannelException e) {
                e.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(VirtualBuffer virtualBuffer, UdpAioSession session) {
        if (this.send(virtualBuffer, session)) {
            return;
        }
        this.responseTasks.offer(new ResponseUnit(session, virtualBuffer));
        UdpChannel udpChannel = this;
        synchronized (udpChannel) {
            if (this.selectionKey == null) {
                this.worker.addRegister(selector -> this.selectionKey.interestOps(this.selectionKey.interestOps() | 4));
            } else if ((this.selectionKey.interestOps() & 4) == 0) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
            }
        }
    }

    void doWrite() {
        ResponseUnit responseUnit;
        do {
            if (this.failResponseUnit == null) {
                responseUnit = this.responseTasks.poll();
            } else {
                responseUnit = this.failResponseUnit;
                this.failResponseUnit = null;
            }
            if (responseUnit != null) continue;
            if (this.responseTasks.isEmpty()) {
                this.selectionKey.interestOps(this.selectionKey.interestOps() & 0xFFFFFFFB);
                if (!this.responseTasks.isEmpty()) {
                    this.selectionKey.interestOps(this.selectionKey.interestOps() | 4);
                }
            }
            return;
        } while (this.send(responseUnit.response, responseUnit.session));
        this.failResponseUnit = responseUnit;
        System.err.println("send fail,will retry...");
    }

    private boolean send(VirtualBuffer virtualBuffer, UdpAioSession session) {
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().beforeWrite((AioSession)session);
        }
        int size = 0;
        try {
            size = this.channel.send(virtualBuffer.buffer(), session.getRemoteAddress());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (size == 0) {
            return false;
        }
        if (this.config.getMonitor() != null) {
            this.config.getMonitor().afterWrite((AioSession)session, size);
        }
        virtualBuffer.clean();
        session.byteBuf.finishWrite();
        session.writeBuffer().flush();
        return true;
    }

    public AioSession connect(SocketAddress remote) {
        return new UdpAioSession(this, remote, this.writeBufferPage);
    }

    public AioSession connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    public void close() {
        ResponseUnit task;
        if (this.selectionKey != null) {
            Selector selector = this.selectionKey.selector();
            this.selectionKey.cancel();
            selector.wakeup();
            this.selectionKey = null;
        }
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException selector) {
            // empty catch block
        }
        while ((task = this.responseTasks.poll()) != null) {
            task.response.clean();
        }
        if (this.failResponseUnit != null) {
            this.failResponseUnit.response.clean();
        }
    }

    DatagramChannel getChannel() {
        return this.channel;
    }

    static final class ResponseUnit {
        private final UdpAioSession session;
        private final VirtualBuffer response;

        public ResponseUnit(UdpAioSession session, VirtualBuffer response) {
            this.session = session;
            this.response = response;
        }
    }
}

