/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.executor.ShardingExecuteCallback;
import io.shardingsphere.core.executor.ShardingExecuteDataMap;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.ShardingGroupExecuteCallback;
import io.shardingsphere.core.executor.ShardingThreadFactoryBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public final class ShardingExecuteEngine
implements AutoCloseable {
    private static final ExecutorService SHUTDOWN_EXECUTOR = Executors.newSingleThreadExecutor(ShardingThreadFactoryBuilder.build("Executor-Engine-Closer"));
    private final ListeningExecutorService executorService;

    public ShardingExecuteEngine(int executorSize) {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)(0 == executorSize ? Executors.newCachedThreadPool(ShardingThreadFactoryBuilder.build()) : Executors.newFixedThreadPool(executorSize, ShardingThreadFactoryBuilder.build())));
        MoreExecutors.addDelayedShutdownHook((ExecutorService)this.executorService, (long)60L, (TimeUnit)TimeUnit.SECONDS);
    }

    public <I, O> List<O> execute(Collection<I> inputs, ShardingExecuteCallback<I, O> callback) throws SQLException {
        return this.execute(inputs, null, callback);
    }

    public <I, O> List<O> execute(Collection<I> inputs, ShardingExecuteCallback<I, O> firstCallback, ShardingExecuteCallback<I, O> callback) throws SQLException {
        if (inputs.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<I> inputIterator = inputs.iterator();
        I firstInput = inputIterator.next();
        Collection<ListenableFuture<O>> restFutures = this.asyncExecute(Lists.newArrayList(inputIterator), callback);
        return this.getResults(this.syncExecute(firstInput, null == firstCallback ? callback : firstCallback), restFutures);
    }

    private <I, O> Collection<ListenableFuture<O>> asyncExecute(Collection<I> inputs, final ShardingExecuteCallback<I, O> callback) {
        ArrayList<ListenableFuture<O>> result = new ArrayList<ListenableFuture<O>>(inputs.size());
        final Map<String, Object> dataMap = ShardingExecuteDataMap.getDataMap();
        for (final I each : inputs) {
            result.add(this.executorService.submit(new Callable<O>(){

                @Override
                public O call() throws SQLException {
                    ShardingExecuteDataMap.setDataMap(dataMap);
                    return callback.execute(each, false);
                }
            }));
        }
        return result;
    }

    private <I, O> O syncExecute(I input, ShardingExecuteCallback<I, O> callback) throws SQLException {
        return callback.execute(input, true);
    }

    private <O> List<O> getResults(O firstResult, Collection<ListenableFuture<O>> restFutures) throws SQLException {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(firstResult);
        for (ListenableFuture<O> each : restFutures) {
            try {
                result.add(each.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                return this.throwException(ex);
            }
        }
        return result;
    }

    public <I, O> List<O> groupExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        return this.groupExecute(inputGroups, null, callback);
    }

    public <I, O> List<O> groupExecute(Collection<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> firstCallback, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        if (inputGroups.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<ShardingExecuteGroup<I>> inputGroupsIterator = inputGroups.iterator();
        ShardingExecuteGroup<I> firstInputs = inputGroupsIterator.next();
        Collection<ListenableFuture<Collection<O>>> restResultFutures = this.asyncGroupExecute(Lists.newArrayList(inputGroupsIterator), callback);
        return this.getGroupResults(this.syncGroupExecute(firstInputs, null == firstCallback ? callback : firstCallback), restResultFutures);
    }

    private <I, O> Collection<ListenableFuture<Collection<O>>> asyncGroupExecute(List<ShardingExecuteGroup<I>> inputGroups, ShardingGroupExecuteCallback<I, O> callback) {
        LinkedList<ListenableFuture<Collection<O>>> result = new LinkedList<ListenableFuture<Collection<O>>>();
        for (ShardingExecuteGroup<I> each : inputGroups) {
            result.add(this.asyncGroupExecute(each, callback));
        }
        return result;
    }

    private <I, O> ListenableFuture<Collection<O>> asyncGroupExecute(final ShardingExecuteGroup<I> inputGroup, final ShardingGroupExecuteCallback<I, O> callback) {
        final Map<String, Object> dataMap = ShardingExecuteDataMap.getDataMap();
        return this.executorService.submit(new Callable<Collection<O>>(){

            @Override
            public Collection<O> call() throws SQLException {
                ShardingExecuteDataMap.setDataMap(dataMap);
                return callback.execute(inputGroup.getInputs(), false);
            }
        });
    }

    private <I, O> Collection<O> syncGroupExecute(ShardingExecuteGroup<I> executeGroup, ShardingGroupExecuteCallback<I, O> callback) throws SQLException {
        return callback.execute(executeGroup.getInputs(), true);
    }

    private <O> List<O> getGroupResults(Collection<O> firstResults, Collection<ListenableFuture<Collection<O>>> restFutures) throws SQLException {
        LinkedList<O> result = new LinkedList<O>();
        result.addAll(firstResults);
        for (ListenableFuture<Collection<O>> each : restFutures) {
            try {
                result.addAll((Collection)each.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                return this.throwException(ex);
            }
        }
        return result;
    }

    private <O> List<O> throwException(Exception ex) throws SQLException {
        if (ex.getCause() instanceof SQLException) {
            throw (SQLException)ex.getCause();
        }
        throw new ShardingException(ex);
    }

    @Override
    public void close() {
        SHUTDOWN_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ShardingExecuteEngine.this.executorService.shutdown();
                    while (!ShardingExecuteEngine.this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                        ShardingExecuteEngine.this.executorService.shutdownNow();
                    }
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }
}

