/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.parser.sql.dcl;

import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.lexer.token.Keyword;
import io.shardingsphere.core.parsing.lexer.token.Symbol;
import io.shardingsphere.core.parsing.lexer.token.TokenType;
import io.shardingsphere.core.parsing.parser.sql.AbstractSQLStatement;
import java.util.Arrays;
import java.util.Collection;

public class DCLStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.GRANT, DefaultKeyword.REVOKE, DefaultKeyword.DENY);
    private static final Collection<Keyword> PRIMARY_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.CREATE, DefaultKeyword.ALTER, DefaultKeyword.DROP, DefaultKeyword.RENAME);
    private static final Collection<Keyword> SECONDARY_STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.LOGIN, DefaultKeyword.USER, DefaultKeyword.ROLE);

    public DCLStatement() {
        super(SQLType.DCL);
    }

    public static boolean isDCL(TokenType primaryTokenType, TokenType secondaryTokenType) {
        return STATEMENT_PREFIX.contains(primaryTokenType) || PRIMARY_STATEMENT_PREFIX.contains(primaryTokenType) && SECONDARY_STATEMENT_PREFIX.contains(secondaryTokenType);
    }

    public boolean isGrantForSingleTable() {
        return !this.getTables().isEmpty() && !this.getTables().getSingleTableName().equals(Symbol.STAR.getLiterals());
    }

    @Override
    public String toString() {
        return "DCLStatement(super=" + super.toString() + ")";
    }
}

