/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.standard;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.shardingsphere.api.algorithm.sharding.ShardingValue;
import io.shardingsphere.core.hint.HintManagerHolder;
import io.shardingsphere.core.optimizer.condition.ShardingCondition;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.optimizer.insert.InsertShardingCondition;
import io.shardingsphere.core.routing.strategy.ShardingStrategy;
import io.shardingsphere.core.routing.strategy.hint.HintShardingStrategy;
import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.rule.TableRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public final class StandardRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final String logicTableName;
    private final ShardingConditions shardingConditions;

    @Override
    public RoutingResult route() {
        TableRule tableRule = this.shardingRule.getTableRuleByLogicTableName(this.logicTableName);
        LinkedList<DataNode> dataNodes = new LinkedList<DataNode>();
        if (this.isRoutingByHint(tableRule)) {
            dataNodes.addAll(this.routeByHint(tableRule));
        } else {
            dataNodes.addAll(this.routeByShardingConditions(tableRule));
        }
        return this.generateRoutingResult(dataNodes);
    }

    private Collection<DataNode> route(TableRule tableRule, List<ShardingValue> databaseShardingValues, List<ShardingValue> tableShardingValues) {
        Collection<String> routedDataSources = this.routeDataSources(tableRule, databaseShardingValues);
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedDataSources) {
            result.addAll(this.routeTables(tableRule, each, tableShardingValues));
        }
        return result;
    }

    private boolean isRoutingByHint(TableRule tableRule) {
        return this.shardingRule.getDatabaseShardingStrategy(tableRule) instanceof HintShardingStrategy && this.shardingRule.getTableShardingStrategy(tableRule) instanceof HintShardingStrategy;
    }

    private boolean isGettingShardingValuesFromHint(ShardingStrategy shardingStrategy) {
        return shardingStrategy instanceof HintShardingStrategy;
    }

    private Collection<DataNode> routeByHint(TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        List<ShardingValue> databaseShardingValues = this.getDatabaseShardingValuesFromHint();
        List<ShardingValue> tableShardingValues = this.getTableShardingValuesFromHint();
        result.addAll(this.route(tableRule, databaseShardingValues, tableShardingValues));
        this.reviseShardingConditions(result);
        return result;
    }

    private Collection<DataNode> routeByShardingConditions(TableRule tableRule) {
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        if (this.shardingConditions.getShardingConditions().isEmpty()) {
            result.addAll(this.route(tableRule, Collections.emptyList(), Collections.emptyList()));
        } else {
            ShardingStrategy dataBaseShardingStrategy = this.shardingRule.getDatabaseShardingStrategy(tableRule);
            ShardingStrategy tableShardingStrategy = this.shardingRule.getTableShardingStrategy(tableRule);
            for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
                List<ShardingValue> databaseShardingValues = this.isGettingShardingValuesFromHint(dataBaseShardingStrategy) ? this.getDatabaseShardingValuesFromHint() : this.getShardingValues(dataBaseShardingStrategy.getShardingColumns(), each);
                List<ShardingValue> tableShardingValues = this.isGettingShardingValuesFromHint(tableShardingStrategy) ? this.getTableShardingValuesFromHint() : this.getShardingValues(tableShardingStrategy.getShardingColumns(), each);
                Collection<DataNode> dataNodes = this.route(tableRule, databaseShardingValues, tableShardingValues);
                this.reviseShardingConditions(each, dataNodes);
                result.addAll(dataNodes);
            }
        }
        return result;
    }

    private void reviseShardingConditions(Collection<DataNode> dataNodes) {
        for (ShardingCondition each : this.shardingConditions.getShardingConditions()) {
            this.reviseShardingConditions(each, dataNodes);
        }
    }

    private void reviseShardingConditions(ShardingCondition each, Collection<DataNode> dataNodes) {
        if (each instanceof InsertShardingCondition) {
            ((InsertShardingCondition)each).getDataNodes().addAll(dataNodes);
        }
    }

    private List<ShardingValue> getDatabaseShardingValuesFromHint() {
        Optional<ShardingValue> shardingValueOptional = HintManagerHolder.getDatabaseShardingValue(this.logicTableName);
        return shardingValueOptional.isPresent() ? Collections.singletonList(shardingValueOptional.get()) : Collections.emptyList();
    }

    private List<ShardingValue> getTableShardingValuesFromHint() {
        Optional<ShardingValue> shardingValueOptional = HintManagerHolder.getTableShardingValue(this.logicTableName);
        return shardingValueOptional.isPresent() ? Collections.singletonList(shardingValueOptional.get()) : Collections.emptyList();
    }

    private List<ShardingValue> getShardingValues(Collection<String> shardingColumns, ShardingCondition shardingCondition) {
        ArrayList<ShardingValue> result = new ArrayList<ShardingValue>(shardingColumns.size());
        for (ShardingValue each : shardingCondition.getShardingValues()) {
            if (!this.logicTableName.equals(each.getLogicTableName()) || !shardingColumns.contains(each.getColumnName())) continue;
            result.add(each);
        }
        return result;
    }

    private Collection<String> routeDataSources(TableRule tableRule, List<ShardingValue> databaseShardingValues) {
        Collection<String> availableTargetDatabases = tableRule.getActualDatasourceNames();
        if (databaseShardingValues.isEmpty()) {
            return availableTargetDatabases;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.shardingRule.getDatabaseShardingStrategy(tableRule).doSharding(availableTargetDatabases, databaseShardingValues));
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)"no database route info");
        return result;
    }

    private Collection<DataNode> routeTables(TableRule tableRule, String routedDataSource, List<ShardingValue> tableShardingValues) {
        Collection<String> availableTargetTables = tableRule.getActualTableNames(routedDataSource);
        LinkedHashSet<String> routedTables = new LinkedHashSet<String>(tableShardingValues.isEmpty() ? availableTargetTables : this.shardingRule.getTableShardingStrategy(tableRule).doSharding(availableTargetTables, tableShardingValues));
        Preconditions.checkState((!routedTables.isEmpty() ? 1 : 0) != 0, (Object)"no table route info");
        LinkedList<DataNode> result = new LinkedList<DataNode>();
        for (String each : routedTables) {
            result.add(new DataNode(routedDataSource, each));
        }
        return result;
    }

    private RoutingResult generateRoutingResult(Collection<DataNode> routedDataNodes) {
        RoutingResult result = new RoutingResult();
        for (DataNode each : routedDataNodes) {
            TableUnit tableUnit = new TableUnit(each.getDataSourceName());
            tableUnit.getRoutingTables().add(new RoutingTable(this.logicTableName, each.getTableName()));
            result.getTableUnits().getTableUnits().add(tableUnit);
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "logicTableName", "shardingConditions"})
    public StandardRoutingEngine(ShardingRule shardingRule, String logicTableName, ShardingConditions shardingConditions) {
        this.shardingRule = shardingRule;
        this.logicTableName = logicTableName;
        this.shardingConditions = shardingConditions;
    }
}

