/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.routing.type.unicast;

import io.shardingsphere.core.routing.type.RoutingEngine;
import io.shardingsphere.core.routing.type.RoutingResult;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.DataNode;
import io.shardingsphere.core.rule.ShardingRule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;

public final class UnicastRoutingEngine
implements RoutingEngine {
    private final ShardingRule shardingRule;
    private final Collection<String> logicTables;

    @Override
    public RoutingResult route() {
        RoutingResult result = new RoutingResult();
        if (this.logicTables.isEmpty()) {
            result.getTableUnits().getTableUnits().add(new TableUnit(this.shardingRule.getShardingDataSourceNames().getDataSourceNames().iterator().next()));
        } else if (1 == this.logicTables.size()) {
            String logicTableName = this.logicTables.iterator().next();
            DataNode dataNode = this.shardingRule.findDataNode(logicTableName);
            TableUnit tableUnit = new TableUnit(dataNode.getDataSourceName());
            tableUnit.getRoutingTables().add(new RoutingTable(logicTableName, dataNode.getTableName()));
            result.getTableUnits().getTableUnits().add(tableUnit);
        } else {
            String dataSourceName = null;
            ArrayList<RoutingTable> routingTables = new ArrayList<RoutingTable>(this.logicTables.size());
            for (String each : this.logicTables) {
                DataNode dataNode = this.shardingRule.findDataNode(dataSourceName, each);
                routingTables.add(new RoutingTable(each, dataNode.getTableName()));
                if (null != dataSourceName) continue;
                dataSourceName = dataNode.getDataSourceName();
            }
            TableUnit tableUnit = new TableUnit(dataSourceName);
            tableUnit.getRoutingTables().addAll(routingTables);
            result.getTableUnits().getTableUnits().add(tableUnit);
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "logicTables"})
    public UnicastRoutingEngine(ShardingRule shardingRule, Collection<String> logicTables) {
        this.shardingRule = shardingRule;
        this.logicTables = logicTables;
    }
}

