/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.differ;

import org.anyline.metadata.Table;
import org.anyline.metadata.differ.AbstractDiffer;
import org.anyline.metadata.differ.ColumnsDiffer;
import org.anyline.metadata.differ.IndexesDiffer;
import org.anyline.metadata.differ.MetadataDiffer;
import org.anyline.metadata.differ.PrimaryKeyDiffer;
import org.anyline.metadata.differ.TriggersDiffer;

public class TableDiffer
extends AbstractDiffer {
    private Table origin;
    private Table dest;
    private ColumnsDiffer columnsDiffer;
    private PrimaryKeyDiffer primaryKeyDiffer;
    private IndexesDiffer indexesDiffer;
    private TriggersDiffer triggersDiffer;

    public TableDiffer() {
    }

    public TableDiffer(Table origin, Table dest) {
        this.origin = origin;
        this.dest = dest;
    }

    @Override
    public MetadataDiffer setDirect(MetadataDiffer.DIRECT direct) {
        if (direct == MetadataDiffer.DIRECT.ORIGIN) {
            this.direct = this.origin;
        } else if (direct == MetadataDiffer.DIRECT.DEST) {
            this.direct = this.dest;
        }
        if (null != this.columnsDiffer) {
            this.columnsDiffer.setDirect(this.direct);
        }
        return this;
    }

    public boolean isEmpty() {
        if (null != this.columnsDiffer && !this.columnsDiffer.isEmpty()) {
            return false;
        }
        return null == this.indexesDiffer || this.indexesDiffer.isEmpty();
    }

    public static TableDiffer compare(Table origin, Table dest, Table direct) {
        if (null == dest) {
            dest = new Table();
        }
        if (null == direct) {
            direct = null != origin ? origin : dest;
        }
        TableDiffer differ = new TableDiffer(origin, dest);
        differ.setColumnsDiffer(ColumnsDiffer.compare(origin.getColumns(), dest.getColumns(), direct));
        differ.setPrimaryKeyDiffer(PrimaryKeyDiffer.compare(origin.getPrimaryKey(), dest.getPrimaryKey(), direct));
        differ.setIndexesDiffer(IndexesDiffer.compare(origin.getIndexes(), dest.getIndexes(), direct));
        differ.setDirect(direct);
        return differ;
    }

    public ColumnsDiffer getColumnsDiffer() {
        return this.columnsDiffer;
    }

    public void setColumnsDiffer(ColumnsDiffer columnsDiffer) {
        this.columnsDiffer = columnsDiffer;
    }

    public PrimaryKeyDiffer getPrimaryKeyDiffer() {
        return this.primaryKeyDiffer;
    }

    public void setPrimaryKeyDiffer(PrimaryKeyDiffer primaryKeyDiffer) {
        this.primaryKeyDiffer = primaryKeyDiffer;
    }

    public IndexesDiffer getIndexesDiffer() {
        return this.indexesDiffer;
    }

    public void setIndexesDiffer(IndexesDiffer indexesDiffer) {
        this.indexesDiffer = indexesDiffer;
    }

    public TriggersDiffer getTriggersDiffer() {
        return this.triggersDiffer;
    }

    public void setTriggersDiffer(TriggersDiffer triggersDiffer) {
        this.triggersDiffer = triggersDiffer;
    }

    public Table getOrigin() {
        return this.origin;
    }

    public void setOrigin(Table origin) {
        this.origin = origin;
    }

    public Table getDest() {
        return this.dest;
    }

    public void setDest(Table dest) {
        this.dest = dest;
    }
}

