/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter.tps;

import java.util.concurrent.atomic.LongAdder;

class StatItem {
    private String name;
    private long lastResetTime;
    private long interval;
    private LongAdder token;
    private int rate;

    StatItem(String name, int rate, long interval) {
        this.name = name;
        this.rate = rate;
        this.interval = interval;
        this.lastResetTime = System.currentTimeMillis();
        this.token = this.buildLongAdder(rate);
    }

    public boolean isAllowable() {
        long now = System.currentTimeMillis();
        if (now > this.lastResetTime + this.interval) {
            this.token = this.buildLongAdder(this.rate);
            this.lastResetTime = now;
        }
        if (this.token.sum() < 0L) {
            return false;
        }
        this.token.decrement();
        return true;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getRate() {
        return this.rate;
    }

    long getLastResetTime() {
        return this.lastResetTime;
    }

    long getToken() {
        return this.token.sum();
    }

    public String toString() {
        return new StringBuilder(32).append("StatItem ").append("[name=").append(this.name).append(", ").append("rate = ").append(this.rate).append(", ").append("interval = ").append(this.interval).append("]").toString();
    }

    private LongAdder buildLongAdder(int rate) {
        LongAdder adder = new LongAdder();
        adder.add(rate);
        return adder;
    }
}

