/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config.ingest;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.metadata.ActualTableName;
import org.apache.shardingsphere.data.pipeline.api.metadata.ColumnName;
import org.apache.shardingsphere.data.pipeline.api.metadata.IdentifierName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;

public class DumperConfiguration {
    private String jobId;
    private String dataSourceName;
    private PipelineDataSourceConfiguration dataSourceConfig;
    private IngestPosition<?> position;
    private Map<ActualTableName, LogicTableName> tableNameMap;
    private TableNameSchemaNameMapping tableNameSchemaNameMapping;
    private Map<LogicTableName, Set<ColumnName>> targetTableColumnsMap;
    private boolean decodeWithTX;

    public LogicTableName getLogicTableName(String actualTableName) {
        return this.tableNameMap.get(new ActualTableName(actualTableName));
    }

    private LogicTableName getLogicTableName(ActualTableName actualTableName) {
        return this.tableNameMap.get(actualTableName);
    }

    public boolean containsTable(String actualTableName) {
        return this.tableNameMap.containsKey(new ActualTableName(actualTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.tableNameSchemaNameMapping.getSchemaName(logicTableName);
    }

    public String getSchemaName(ActualTableName actualTableName) {
        return this.tableNameSchemaNameMapping.getSchemaName(this.getLogicTableName(actualTableName));
    }

    public Optional<List<String>> getColumnNameList(LogicTableName logicTableName) {
        Set<ColumnName> columnNames;
        Set<ColumnName> set = columnNames = null != this.targetTableColumnsMap ? this.targetTableColumnsMap.get(logicTableName) : null;
        if (null == columnNames) {
            return Optional.empty();
        }
        return Optional.of(columnNames.stream().map(IdentifierName::getOriginal).collect(Collectors.toList()));
    }

    public Optional<Set<ColumnName>> getColumnNameSet(String actualTableName) {
        Set<ColumnName> result = null != this.targetTableColumnsMap ? this.targetTableColumnsMap.get(this.getLogicTableName(actualTableName)) : null;
        return Optional.ofNullable(result);
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Generated
    public PipelineDataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public IngestPosition<?> getPosition() {
        return this.position;
    }

    @Generated
    public Map<ActualTableName, LogicTableName> getTableNameMap() {
        return this.tableNameMap;
    }

    @Generated
    public TableNameSchemaNameMapping getTableNameSchemaNameMapping() {
        return this.tableNameSchemaNameMapping;
    }

    @Generated
    public boolean isDecodeWithTX() {
        return this.decodeWithTX;
    }

    @Generated
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Generated
    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    @Generated
    public void setDataSourceConfig(PipelineDataSourceConfiguration dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    @Generated
    public void setPosition(IngestPosition<?> position) {
        this.position = position;
    }

    @Generated
    public void setTableNameMap(Map<ActualTableName, LogicTableName> tableNameMap) {
        this.tableNameMap = tableNameMap;
    }

    @Generated
    public void setTableNameSchemaNameMapping(TableNameSchemaNameMapping tableNameSchemaNameMapping) {
        this.tableNameSchemaNameMapping = tableNameSchemaNameMapping;
    }

    @Generated
    public void setTargetTableColumnsMap(Map<LogicTableName, Set<ColumnName>> targetTableColumnsMap) {
        this.targetTableColumnsMap = targetTableColumnsMap;
    }

    @Generated
    public void setDecodeWithTX(boolean decodeWithTX) {
        this.decodeWithTX = decodeWithTX;
    }

    @Generated
    public String toString() {
        return "DumperConfiguration(jobId=" + this.getJobId() + ", dataSourceName=" + this.getDataSourceName() + ", position=" + this.getPosition() + ", tableNameMap=" + this.getTableNameMap() + ", targetTableColumnsMap=" + this.getTargetTableColumnsMap() + ", decodeWithTX=" + this.isDecodeWithTX() + ")";
    }

    @Generated
    protected Map<LogicTableName, Set<ColumnName>> getTargetTableColumnsMap() {
        return this.targetTableColumnsMap;
    }
}

