/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.util.spi;

import java.util.Optional;
import org.apache.shardingsphere.infra.database.type.BranchDatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.util.spi.exception.ServiceProviderNotFoundServerException;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPILoader;

public final class PipelineTypedSPILoader {
    public static <T extends TypedSPI> Optional<T> findDatabaseTypedService(Class<T> spiClass, String databaseType) {
        Optional result = TypedSPILoader.findService(spiClass, (String)databaseType);
        if (result.isPresent()) {
            return result;
        }
        Optional type = TypedSPILoader.findService(DatabaseType.class, (String)databaseType);
        if (type.isPresent() && type.get() instanceof BranchDatabaseType) {
            return TypedSPILoader.findService(spiClass, (String)((BranchDatabaseType)type.get()).getTrunkDatabaseType().getType());
        }
        return result;
    }

    public static <T extends TypedSPI> T getDatabaseTypedService(Class<T> spiClass, String databaseType) {
        return (T)((TypedSPI)PipelineTypedSPILoader.findDatabaseTypedService(spiClass, databaseType).orElseThrow(() -> new ServiceProviderNotFoundServerException(spiClass)));
    }
}

