/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.original;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutionUnit;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutor;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.JDBCExecutorCallback;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DriverExecutionPrepareEngine;
import org.apache.shardingsphere.infra.federation.executor.FederationContext;
import org.apache.shardingsphere.infra.federation.executor.FederationExecutor;
import org.apache.shardingsphere.infra.federation.executor.common.table.CommonTableScanExecutorContext;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.context.OptimizerContext;
import org.apache.shardingsphere.infra.federation.optimizer.context.parser.OptimizerParserContext;
import org.apache.shardingsphere.infra.federation.optimizer.executor.TableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.filter.FilterableDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class OriginalFederationExecutor
implements FederationExecutor {
    public static final String CONNECTION_URL = "jdbc:calcite:";
    public static final String DRIVER_NAME = "org.apache.calcite.jdbc.Driver";
    private final String databaseName;
    private final String schemaName;
    private final OptimizerContext optimizerContext;
    private final ShardingSphereRuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final JDBCExecutor jdbcExecutor;
    private final EventBusContext eventBusContext;
    private Statement statement;

    @Override
    public ResultSet executeQuery(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        Connection connection = this.createConnection(prepareEngine, callback, federationContext);
        PreparedStatement preparedStatement = connection.prepareStatement(SQLUtil.trimSemicolon((String)federationContext.getQueryContext().getSql()));
        this.setParameters(preparedStatement, federationContext.getQueryContext().getParameters());
        this.statement = preparedStatement;
        return preparedStatement.executeQuery();
    }

    private Connection createConnection(DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        Connection result = DriverManager.getConnection(CONNECTION_URL, ((OptimizerParserContext)this.optimizerContext.getParserContexts().get(this.databaseName)).getDialectProps());
        this.addSchema(result.unwrap(CalciteConnection.class), prepareEngine, callback, federationContext);
        return result;
    }

    private void addSchema(CalciteConnection connection, DriverExecutionPrepareEngine<JDBCExecutionUnit, Connection> prepareEngine, JDBCExecutorCallback<? extends ExecuteResult> callback, FederationContext federationContext) throws SQLException {
        CommonTableScanExecutorContext executorContext = new CommonTableScanExecutorContext(this.databaseName, this.schemaName, this.props, federationContext);
        FilterableTableScanExecutor executor = new FilterableTableScanExecutor(prepareEngine, this.jdbcExecutor, callback, this.optimizerContext, this.globalRuleMetaData, executorContext, this.eventBusContext);
        FilterableDatabase database = new FilterableDatabase(federationContext.getDatabases().get(this.databaseName.toLowerCase()), (TableScanExecutor)executor);
        connection.getRootSchema().add(this.schemaName, database.getSubSchema(this.schemaName));
        connection.setSchema(this.schemaName);
    }

    private void setParameters(PreparedStatement preparedStatement, List<Object> parameters) throws SQLException {
        int count = 1;
        for (Object each : parameters) {
            preparedStatement.setObject(count, each);
            ++count;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    @Override
    public void close() throws SQLException {
        if (null != this.statement && !this.statement.isClosed()) {
            Connection connection = this.statement.getConnection();
            this.statement.close();
            connection.close();
        }
    }

    @Generated
    public OriginalFederationExecutor(String databaseName, String schemaName, OptimizerContext optimizerContext, ShardingSphereRuleMetaData globalRuleMetaData, ConfigurationProperties props, JDBCExecutor jdbcExecutor, EventBusContext eventBusContext) {
        this.databaseName = databaseName;
        this.schemaName = schemaName;
        this.optimizerContext = optimizerContext;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.jdbcExecutor = jdbcExecutor;
        this.eventBusContext = eventBusContext;
    }

    static {
        try {
            Class.forName(DRIVER_NAME);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }
}

