// Targeted by JavaCPP version 0.8

package org.bytedeco.javacpp;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.opencv_core.*;

public class opencv_flann extends org.bytedeco.javacpp.presets.opencv_flann {
    static { Loader.load(); }

// Parsed from /usr/local/include/opencv2/flann/defines.h

/***********************************************************************
 * Software License Agreement (BSD License)
 *
 * Copyright 2008-2011  Marius Muja (mariusm@cs.ubc.ca). All rights reserved.
 * Copyright 2008-2011  David G. Lowe (lowe@cs.ubc.ca). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *************************************************************************/


// #ifndef OPENCV_FLANN_DEFINES_H_
// #define OPENCV_FLANN_DEFINES_H_

// #include "config.h"

// #ifdef FLANN_EXPORT
// #endif
// #ifdef WIN32
/* win32 dll export/import directives */
//  #ifdef FLANN_EXPORTS
//   #define FLANN_EXPORT __declspec(dllexport)
//  #elif defined(FLANN_STATIC)
//   #define FLANN_EXPORT
//  #else
//   #define FLANN_EXPORT __declspec(dllimport)
//  #endif
// #else
/* unix needs nothing */
//  #define FLANN_EXPORT
// #endif


// #ifdef FLANN_DEPRECATED
// #endif
// #ifdef __GNUC__
// #define FLANN_DEPRECATED __attribute__ ((deprecated))
// #elif defined(_MSC_VER)
// #define FLANN_DEPRECATED __declspec(deprecated)
// #else
// #pragma message("WARNING: You need to implement FLANN_DEPRECATED for this compiler")
// #define FLANN_DEPRECATED
// #endif


// #undef FLANN_PLATFORM_32_BIT
// #undef FLANN_PLATFORM_64_BIT
// #if defined __amd64__ || defined __x86_64__ || defined _WIN64 || defined _M_X64
// #define FLANN_PLATFORM_64_BIT
// #else
// #define FLANN_PLATFORM_32_BIT
// #endif


// #undef FLANN_ARRAY_LEN
// #define FLANN_ARRAY_LEN(a) (sizeof(a)/sizeof(a[0]))

/* Nearest neighbour index algorithms */
/** enum cvflann::flann_algorithm_t */
public static final int
    FLANN_INDEX_LINEAR = 0,
    FLANN_INDEX_KDTREE = 1,
    FLANN_INDEX_KMEANS = 2,
    FLANN_INDEX_COMPOSITE = 3,
    FLANN_INDEX_KDTREE_SINGLE = 4,
    FLANN_INDEX_HIERARCHICAL = 5,
    FLANN_INDEX_LSH = 6,
    FLANN_INDEX_SAVED = 254,
    FLANN_INDEX_AUTOTUNED = 255,

    // deprecated constants, should use the FLANN_INDEX_* ones instead
    LINEAR = 0,
    KDTREE = 1,
    KMEANS = 2,
    COMPOSITE = 3,
    KDTREE_SINGLE = 4,
    SAVED = 254,
    AUTOTUNED = 255;



/** enum cvflann::flann_centers_init_t */
public static final int
    FLANN_CENTERS_RANDOM = 0,
    FLANN_CENTERS_GONZALES = 1,
    FLANN_CENTERS_KMEANSPP = 2,

    // deprecated constants, should use the FLANN_CENTERS_* ones instead
    CENTERS_RANDOM = 0,
    CENTERS_GONZALES = 1,
    CENTERS_KMEANSPP = 2;

/** enum cvflann::flann_log_level_t */
public static final int
    FLANN_LOG_NONE = 0,
    FLANN_LOG_FATAL = 1,
    FLANN_LOG_ERROR = 2,
    FLANN_LOG_WARN = 3,
    FLANN_LOG_INFO = 4;

/** enum cvflann::flann_distance_t */
public static final int
    FLANN_DIST_EUCLIDEAN = 1,
    FLANN_DIST_L2 = 1,
    FLANN_DIST_MANHATTAN = 2,
    FLANN_DIST_L1 = 2,
    FLANN_DIST_MINKOWSKI = 3,
    FLANN_DIST_MAX   = 4,
    FLANN_DIST_HIST_INTERSECT   = 5,
    FLANN_DIST_HELLINGER = 6,
    FLANN_DIST_CHI_SQUARE = 7,
    FLANN_DIST_CS         = 7,
    FLANN_DIST_KULLBACK_LEIBLER  = 8,
    FLANN_DIST_KL                = 8,
    FLANN_DIST_HAMMING          = 9,

    // deprecated constants, should use the FLANN_DIST_* ones instead
    EUCLIDEAN = 1,
    MANHATTAN = 2,
    MINKOWSKI = 3,
    MAX_DIST   = 4,
    HIST_INTERSECT   = 5,
    HELLINGER = 6,
    CS         = 7,
    KL         = 8,
    KULLBACK_LEIBLER  = 8;

/** enum cvflann::flann_datatype_t */
public static final int
    FLANN_INT8 = 0,
    FLANN_INT16 = 1,
    FLANN_INT32 = 2,
    FLANN_INT64 = 3,
    FLANN_UINT8 = 4,
    FLANN_UINT16 = 5,
    FLANN_UINT32 = 6,
    FLANN_UINT64 = 7,
    FLANN_FLOAT32 = 8,
    FLANN_FLOAT64 = 9;

/** enum cvflann:: */
public static final int
    FLANN_CHECKS_UNLIMITED = -1,
    FLANN_CHECKS_AUTOTUNED = -2;



// #endif /* OPENCV_FLANN_DEFINES_H_ */


// Parsed from /usr/local/include/opencv2/flann/miniflann.hpp

/*M///////////////////////////////////////////////////////////////////////////////////////
//
//  IMPORTANT: READ BEFORE DOWNLOADING, COPYING, INSTALLING OR USING.
//
//  By downloading, copying, installing or using the software you agree to this license.
//  If you do not agree to this license, do not download, install,
//  copy or use the software.
//
//
//                           License Agreement
//                For Open Source Computer Vision Library
//
// Copyright (C) 2000-2008, Intel Corporation, all rights reserved.
// Copyright (C) 2009, Willow Garage Inc., all rights reserved.
// Third party copyrights are property of their respective owners.
//
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
//
//   * Redistribution's of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//
//   * Redistribution's in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//
//   * The name of the copyright holders may not be used to endorse or promote products
//     derived from this software without specific prior written permission.
//
// This software is provided by the copyright holders and contributors "as is" and
// any express or implied warranties, including, but not limited to, the implied
// warranties of merchantability and fitness for a particular purpose are disclaimed.
// In no event shall the Intel Corporation or contributors be liable for any direct,
// indirect, incidental, special, exemplary, or consequential damages
// (including, but not limited to, procurement of substitute goods or services;
// loss of use, data, or profits; or business interruption) however caused
// and on any theory of liability, whether in contract, strict liability,
// or tort (including negligence or otherwise) arising in any way out of
// the use of this software, even if advised of the possibility of such damage.
//
//M*/

// #ifndef _OPENCV_MINIFLANN_HPP_
// #define _OPENCV_MINIFLANN_HPP_

// #ifdef __cplusplus

// #include "opencv2/core/core.hpp"
// #include "opencv2/flann/defines.h"

@Namespace("cv::flann") @NoOffset public static class IndexParams extends Pointer {
    static { Loader.load(); }
    public IndexParams(Pointer p) { super(p); }
    public IndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public IndexParams position(int position) {
        return (IndexParams)super.position(position);
    }

    public IndexParams() { allocate(); }
    private native void allocate();

    public native @StdString BytePointer getString(@StdString BytePointer key, @StdString BytePointer defaultVal/*=std::string()*/);
    public native @StdString BytePointer getString(@StdString BytePointer key);
    public native @StdString String getString(@StdString String key, @StdString String defaultVal/*=std::string()*/);
    public native @StdString String getString(@StdString String key);
    public native int getInt(@StdString BytePointer key, int defaultVal/*=-1*/);
    public native int getInt(@StdString BytePointer key);
    public native int getInt(@StdString String key, int defaultVal/*=-1*/);
    public native int getInt(@StdString String key);
    public native double getDouble(@StdString BytePointer key, double defaultVal/*=-1*/);
    public native double getDouble(@StdString BytePointer key);
    public native double getDouble(@StdString String key, double defaultVal/*=-1*/);
    public native double getDouble(@StdString String key);

    public native void setString(@StdString BytePointer key, @StdString BytePointer value);
    public native void setString(@StdString String key, @StdString String value);
    public native void setInt(@StdString BytePointer key, int value);
    public native void setInt(@StdString String key, int value);
    public native void setDouble(@StdString BytePointer key, double value);
    public native void setDouble(@StdString String key, double value);
    public native void setFloat(@StdString BytePointer key, float value);
    public native void setFloat(@StdString String key, float value);
    public native void setBool(@StdString BytePointer key, @Cast("bool") boolean value);
    public native void setBool(@StdString String key, @Cast("bool") boolean value);
    public native void setAlgorithm(int value);

    public native void getAll(@ByRef StringVector names,
                    @StdVector IntPointer types,
                    @ByRef StringVector strValues,
                    @StdVector DoublePointer numValues);
    public native void getAll(@ByRef StringVector names,
                    @StdVector IntBuffer types,
                    @ByRef StringVector strValues,
                    @StdVector DoubleBuffer numValues);
    public native void getAll(@ByRef StringVector names,
                    @StdVector int[] types,
                    @ByRef StringVector strValues,
                    @StdVector double[] numValues);

    public native Pointer params(); public native IndexParams params(Pointer params);
}

@Namespace("cv::flann") public static class KDTreeIndexParams extends IndexParams {
    static { Loader.load(); }
    public KDTreeIndexParams(Pointer p) { super(p); }

    public KDTreeIndexParams(int trees/*=4*/) { allocate(trees); }
    private native void allocate(int trees/*=4*/);
    public KDTreeIndexParams() { allocate(); }
    private native void allocate();
}

@Namespace("cv::flann") public static class LinearIndexParams extends IndexParams {
    static { Loader.load(); }
    public LinearIndexParams(Pointer p) { super(p); }
    public LinearIndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public LinearIndexParams position(int position) {
        return (LinearIndexParams)super.position(position);
    }

    public LinearIndexParams() { allocate(); }
    private native void allocate();
}

@Namespace("cv::flann") public static class CompositeIndexParams extends IndexParams {
    static { Loader.load(); }
    public CompositeIndexParams(Pointer p) { super(p); }
    public CompositeIndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public CompositeIndexParams position(int position) {
        return (CompositeIndexParams)super.position(position);
    }

    public CompositeIndexParams(int trees/*=4*/, int branching/*=32*/, int iterations/*=11*/,
                             @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, float cb_index/*=0.2*/ ) { allocate(trees, branching, iterations, centers_init, cb_index); }
    private native void allocate(int trees/*=4*/, int branching/*=32*/, int iterations/*=11*/,
                             @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, float cb_index/*=0.2*/ );
    public CompositeIndexParams( ) { allocate(); }
    private native void allocate( );
}

@Namespace("cv::flann") public static class AutotunedIndexParams extends IndexParams {
    static { Loader.load(); }
    public AutotunedIndexParams(Pointer p) { super(p); }
    public AutotunedIndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public AutotunedIndexParams position(int position) {
        return (AutotunedIndexParams)super.position(position);
    }

    public AutotunedIndexParams(float target_precision/*=0.8*/, float build_weight/*=0.01*/,
                             float memory_weight/*=0*/, float sample_fraction/*=0.1*/) { allocate(target_precision, build_weight, memory_weight, sample_fraction); }
    private native void allocate(float target_precision/*=0.8*/, float build_weight/*=0.01*/,
                             float memory_weight/*=0*/, float sample_fraction/*=0.1*/);
    public AutotunedIndexParams() { allocate(); }
    private native void allocate();
}

@Namespace("cv::flann") public static class HierarchicalClusteringIndexParams extends IndexParams {
    static { Loader.load(); }
    public HierarchicalClusteringIndexParams(Pointer p) { super(p); }
    public HierarchicalClusteringIndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public HierarchicalClusteringIndexParams position(int position) {
        return (HierarchicalClusteringIndexParams)super.position(position);
    }

    public HierarchicalClusteringIndexParams(int branching/*=32*/,
                          @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, int trees/*=4*/, int leaf_size/*=100*/ ) { allocate(branching, centers_init, trees, leaf_size); }
    private native void allocate(int branching/*=32*/,
                          @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, int trees/*=4*/, int leaf_size/*=100*/ );
    public HierarchicalClusteringIndexParams( ) { allocate(); }
    private native void allocate( );
}

@Namespace("cv::flann") public static class KMeansIndexParams extends IndexParams {
    static { Loader.load(); }
    public KMeansIndexParams(Pointer p) { super(p); }
    public KMeansIndexParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public KMeansIndexParams position(int position) {
        return (KMeansIndexParams)super.position(position);
    }

    public KMeansIndexParams(int branching/*=32*/, int iterations/*=11*/,
                          @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, float cb_index/*=0.2*/ ) { allocate(branching, iterations, centers_init, cb_index); }
    private native void allocate(int branching/*=32*/, int iterations/*=11*/,
                          @Cast("cvflann::flann_centers_init_t") int centers_init/*=cvflann::FLANN_CENTERS_RANDOM*/, float cb_index/*=0.2*/ );
    public KMeansIndexParams( ) { allocate(); }
    private native void allocate( );
}

@Namespace("cv::flann") public static class LshIndexParams extends IndexParams {
    static { Loader.load(); }
    public LshIndexParams() { }
    public LshIndexParams(Pointer p) { super(p); }

    public LshIndexParams(int table_number, int key_size, int multi_probe_level) { allocate(table_number, key_size, multi_probe_level); }
    private native void allocate(int table_number, int key_size, int multi_probe_level);
}

@Namespace("cv::flann") public static class SavedIndexParams extends IndexParams {
    static { Loader.load(); }
    public SavedIndexParams() { }
    public SavedIndexParams(Pointer p) { super(p); }

    public SavedIndexParams(@StdString BytePointer filename) { allocate(filename); }
    private native void allocate(@StdString BytePointer filename);
    public SavedIndexParams(@StdString String filename) { allocate(filename); }
    private native void allocate(@StdString String filename);
}

@Namespace("cv::flann") public static class SearchParams extends IndexParams {
    static { Loader.load(); }
    public SearchParams(Pointer p) { super(p); }
    public SearchParams(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public SearchParams position(int position) {
        return (SearchParams)super.position(position);
    }

    public SearchParams( int checks/*=32*/, float eps/*=0*/, @Cast("bool") boolean sorted/*=true*/ ) { allocate(checks, eps, sorted); }
    private native void allocate( int checks/*=32*/, float eps/*=0*/, @Cast("bool") boolean sorted/*=true*/ );
    public SearchParams( ) { allocate(); }
    private native void allocate( );
}

@Namespace("cv::flann") @NoOffset public static class Index extends Pointer {
    static { Loader.load(); }
    public Index(Pointer p) { super(p); }
    public Index(int size) { allocateArray(size); }
    private native void allocateArray(int size);
    @Override public Index position(int position) {
        return (Index)super.position(position);
    }

    public Index() { allocate(); }
    private native void allocate();
    public Index(@ByVal Mat features, @Const @ByRef IndexParams params, @Cast("cvflann::flann_distance_t") int distType/*=cvflann::FLANN_DIST_L2*/) { allocate(features, params, distType); }
    private native void allocate(@ByVal Mat features, @Const @ByRef IndexParams params, @Cast("cvflann::flann_distance_t") int distType/*=cvflann::FLANN_DIST_L2*/);
    public Index(@ByVal Mat features, @Const @ByRef IndexParams params) { allocate(features, params); }
    private native void allocate(@ByVal Mat features, @Const @ByRef IndexParams params);

    public native void build(@ByVal Mat features, @Const @ByRef IndexParams params, @Cast("cvflann::flann_distance_t") int distType/*=cvflann::FLANN_DIST_L2*/);
    public native void build(@ByVal Mat features, @Const @ByRef IndexParams params);
    public native void knnSearch(@ByVal Mat query, @ByVal Mat indices,
                       @ByVal Mat dists, int knn, @Const @ByRef SearchParams params/*=SearchParams()*/);
    public native void knnSearch(@ByVal Mat query, @ByVal Mat indices,
                       @ByVal Mat dists, int knn);

    public native int radiusSearch(@ByVal Mat query, @ByVal Mat indices,
                                 @ByVal Mat dists, double radius, int maxResults,
                                 @Const @ByRef SearchParams params/*=SearchParams()*/);
    public native int radiusSearch(@ByVal Mat query, @ByVal Mat indices,
                                 @ByVal Mat dists, double radius, int maxResults);

    public native void save(@StdString BytePointer filename);
    public native void save(@StdString String filename);
    public native @Cast("bool") boolean load(@ByVal Mat features, @StdString BytePointer filename);
    public native @Cast("bool") boolean load(@ByVal Mat features, @StdString String filename);
    public native void release();
    public native @Cast("cvflann::flann_distance_t") int getDistance();
    public native @Cast("cvflann::flann_algorithm_t") int getAlgorithm();
}

  // namespace cv::flann

// #endif // __cplusplus

// #endif


}
