/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dromara.hmily.tac.common.HmilyTacResource;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.metadata.loader.DataSourceMetaDataLoader;
import org.dromara.hmily.tac.metadata.model.DataSourceMetaData;

public class HmilyMetaDataManager {
    private static final Map<String, DataSourceMetaData> DATASOURCE_META_CACHE = new ConcurrentHashMap<String, DataSourceMetaData>();

    public static void register(HmilyTacResource hmilyTacResource, DatabaseType databaseType) {
        DataSourceMetaData dataSourceMetaData;
        try {
            dataSourceMetaData = DataSourceMetaDataLoader.load(hmilyTacResource.getTargetDataSource(), databaseType);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("failed in loading datasource metadata into hmily");
        }
        DATASOURCE_META_CACHE.put(hmilyTacResource.getResourceId(), dataSourceMetaData);
    }

    public static DataSourceMetaData get(String resourceId) {
        return DATASOURCE_META_CACHE.get(resourceId);
    }
}

