/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.tac.metadata.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.dromara.hmily.tac.common.database.type.DatabaseType;
import org.dromara.hmily.tac.metadata.connection.MetaDataConnectionAdapter;
import org.dromara.hmily.tac.metadata.loader.TableMetaDataLoader;
import org.dromara.hmily.tac.metadata.model.DataSourceMetaData;
import org.dromara.hmily.tac.metadata.model.TableMetaData;

public final class DataSourceMetaDataLoader {
    public static DataSourceMetaData load(DataSource dataSource, DatabaseType databaseType) throws SQLException {
        DataSourceMetaData result = new DataSourceMetaData();
        try (MetaDataConnectionAdapter connectionAdapter = new MetaDataConnectionAdapter(databaseType, dataSource.getConnection());){
            for (String each : DataSourceMetaDataLoader.loadAllTableNames(connectionAdapter)) {
                Optional<TableMetaData> tableMetaData = TableMetaDataLoader.load(connectionAdapter, each, databaseType);
                tableMetaData.ifPresent(meta -> result.getTableMetaDataMap().put(each, (TableMetaData)meta));
            }
        }
        return result;
    }

    private static List<String> loadAllTableNames(MetaDataConnectionAdapter connectionAdapter) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        try (ResultSet resultSet = connectionAdapter.getMetaData().getTables(connectionAdapter.getCatalog(), connectionAdapter.getSchema(), null, new String[]{"TABLE"});){
            while (resultSet.next()) {
                String tableName = resultSet.getString("TABLE_NAME");
                if (tableName.contains("$") || tableName.contains("/")) continue;
                result.add(tableName);
            }
        }
        return result;
    }

    private DataSourceMetaDataLoader() {
    }
}

