/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geometry.utils;

import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.BitUtil;

public class Geohash {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String BASE_32_STRING = new String(BASE_32);
    public static final int PRECISION = 12;
    private static final short BITS = 32;
    private static final double LAT_SCALE = 1.1930464711111112E7;
    private static final double LAT_DECODE = 4.190951585769653E-8;
    private static final double LON_SCALE = 5965232.355555556;
    private static final double LON_DECODE = 8.381903171539307E-8;
    private static final short MORTON_OFFSET = 4;
    private static final long MAX_LAT_BITS = 0x3FFFFFFFL;

    private Geohash() {
    }

    public static Point toPoint(String geohash) throws IllegalArgumentException {
        long hash = Geohash.mortonEncode(geohash);
        return new Point(Geohash.decodeLongitude(hash), Geohash.decodeLatitude(hash));
    }

    public static Rectangle toBoundingBox(String geohash) {
        Point bottomLeft = Geohash.toPoint(geohash);
        int len = Math.min(12, geohash.length());
        long ghLong = Geohash.longEncode(geohash, len);
        long lon = BitUtil.deinterleave((ghLong >>>= 4) >>> 1);
        long lat = BitUtil.deinterleave(ghLong);
        int shift = (12 - len) * 5 + 2;
        if (lat < 0x3FFFFFFFL) {
            ghLong = BitUtil.interleave((int)(lat + 1L), (int)(lon + 1L)) << 4 | (long)len;
            long mortonHash = BitUtil.flipFlop(ghLong >>> 4 << shift);
            Point topRight = new Point(Geohash.decodeLongitude(mortonHash), Geohash.decodeLatitude(mortonHash));
            return new Rectangle(bottomLeft.getX(), topRight.getX(), topRight.getY(), bottomLeft.getY());
        }
        ghLong = BitUtil.interleave((int)lat, (int)(lon + 1L)) << 4 | (long)len;
        long mortonHash = BitUtil.flipFlop(ghLong >>> 4 << shift);
        Point topRight = new Point(Geohash.decodeLongitude(mortonHash), Geohash.decodeLatitude(mortonHash));
        return new Rectangle(bottomLeft.getX(), topRight.getX(), 90.0, bottomLeft.getY());
    }

    public static Collection<? extends CharSequence> getNeighbors(String geohash) {
        return Geohash.addNeighborsAtLevel(geohash, geohash.length(), new ArrayList(8));
    }

    public static final <E extends Collection<? super String>> E addNeighbors(String geohash, E neighbors) {
        return Geohash.addNeighborsAtLevel(geohash, geohash.length(), neighbors);
    }

    public static final <E extends Collection<? super String>> E addNeighborsAtLevel(String geohash, int level, E neighbors) {
        String south = Geohash.getNeighbor(geohash, level, 0, -1);
        String north = Geohash.getNeighbor(geohash, level, 0, 1);
        if (north != null) {
            neighbors.add((String)Geohash.getNeighbor(north, level, -1, 0));
            neighbors.add((String)north);
            neighbors.add((String)Geohash.getNeighbor(north, level, 1, 0));
        }
        neighbors.add((String)Geohash.getNeighbor(geohash, level, -1, 0));
        neighbors.add((String)Geohash.getNeighbor(geohash, level, 1, 0));
        if (south != null) {
            neighbors.add((String)Geohash.getNeighbor(south, level, -1, 0));
            neighbors.add((String)south);
            neighbors.add((String)Geohash.getNeighbor(south, level, 1, 0));
        }
        return (E)neighbors;
    }

    public static final String getNeighbor(String geohash, int level, int dx, int dy) {
        int ny;
        int cell = BASE_32_STRING.indexOf(geohash.charAt(level - 1));
        int x0 = cell & 1;
        int y0 = cell & 2;
        int x1 = cell & 4;
        int y1 = cell & 8;
        int x2 = cell & 0x10;
        int x = x0 + x1 / 2 + x2 / 4;
        int y = y0 / 2 + y1 / 4;
        if (level == 1) {
            if (dy < 0 && y == 0 || dy > 0 && y == 3) {
                return null;
            }
            return Character.toString(Geohash.encodeBase32(x + dx, y + dy));
        }
        int nx = level % 2 == 1 ? x + dx : x + dy;
        int n = ny = level % 2 == 1 ? y + dy : y + dx;
        if (nx >= 0 && nx <= 7 && ny >= 0 && ny <= 3) {
            return geohash.substring(0, level - 1) + Geohash.encodeBase32(nx, ny);
        }
        String neighbor = Geohash.getNeighbor(geohash, level - 1, dx, dy);
        return neighbor != null ? neighbor + Geohash.encodeBase32(nx, ny) : neighbor;
    }

    public static final long longEncode(double lon, double lat, int level) {
        short msf = (short)((12 - level) * 5 + 2);
        return Geohash.encodeLatLon(lat, lon) >>> msf << 4 | (long)level;
    }

    public static final String stringEncode(double lon, double lat) {
        return Geohash.stringEncode(lon, lat, 12);
    }

    public static final String stringEncode(double lon, double lat, int level) {
        long interleaved = Geohash.encodeLatLon(lat, lon);
        long geohash = (interleaved >>>= (12 - level) * 5 + 2) << 4 | (long)level;
        return Geohash.stringEncode(geohash);
    }

    public static final String stringEncode(long geoHashLong) {
        int level = (int)geoHashLong & 0xF;
        geoHashLong >>>= 4;
        char[] chars = new char[level];
        do {
            chars[--level] = BASE_32[(int)(geoHashLong & 0x1FL)];
            geoHashLong >>>= 5;
        } while (level > 0);
        return new String(chars);
    }

    private static char encodeBase32(int x, int y) {
        return BASE_32[((x & 1) + (y & 1) * 2 + (x & 2) * 2 + (y & 2) * 4 + (x & 4) * 4) % 32];
    }

    private static long longEncode(String hash, int length) {
        int level = length - 1;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            l |= b << level-- * 5;
            if (level < 0) break;
        }
        return l << 4 | (long)length;
    }

    public static long mortonEncode(String hash) {
        if (hash.isEmpty()) {
            throw new IllegalArgumentException("empty geohash");
        }
        int level = 11;
        long l = 0L;
        for (char c : hash.toCharArray()) {
            long b = BASE_32_STRING.indexOf(c);
            if (b < 0L) {
                throw new IllegalArgumentException("unsupported symbol [" + c + "] in geohash [" + hash + "]");
            }
            l |= b << level-- * 5 + 2;
            if (level < 0) break;
        }
        return BitUtil.flipFlop(l);
    }

    private static long encodeLatLon(double lat, double lon) {
        int latEnc = Geohash.encodeLatitude(lat) ^ Integer.MIN_VALUE;
        int lonEnc = Geohash.encodeLongitude(lon) ^ Integer.MIN_VALUE;
        return BitUtil.interleave(latEnc, lonEnc) >>> 2;
    }

    public static int encodeLatitude(double latitude) {
        if (latitude == 90.0) {
            latitude = Math.nextDown(latitude);
        }
        return (int)Math.floor(latitude / 4.190951585769653E-8);
    }

    public static int encodeLongitude(double longitude) {
        if (longitude == 180.0) {
            longitude = Math.nextDown(longitude);
        }
        return (int)Math.floor(longitude / 8.381903171539307E-8);
    }

    public static final double decodeLatitude(String geohash) {
        return Geohash.decodeLatitude(Geohash.mortonEncode(geohash));
    }

    public static final double decodeLongitude(String geohash) {
        return Geohash.decodeLongitude(Geohash.mortonEncode(geohash));
    }

    public static double decodeLongitude(long hash) {
        return Geohash.unscaleLon(BitUtil.deinterleave(hash));
    }

    public static double decodeLatitude(long hash) {
        return Geohash.unscaleLat(BitUtil.deinterleave(hash >>> 1));
    }

    private static double unscaleLon(long val) {
        return (double)val / 5965232.355555556 - 180.0;
    }

    private static double unscaleLat(long val) {
        return (double)val / 1.1930464711111112E7 - 90.0;
    }
}

